/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.impl;

//$Id: ComplexGatewayImpl.java 1930 2008-08-19 11:04:43Z thomas.diesler@jboss.com $

import org.jboss.bpm.NotImplementedException;
import org.jboss.bpm.model.ComplexGateway;
import org.jboss.bpm.model.Expression;
import org.jboss.bpm.runtime.Token;
import org.jboss.bpm.runtime.TokenExecutor;

/**
 * A Complex Gateway handles situations that are not easily handled through the other types of Gateways. Complex
 * Gateways can also be used to combine a set of linked simple Gateways into a single, more compact situation. Modelers
 * can provide complex expressions that determine the merging and/or splitting behavior of the 
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@SuppressWarnings("serial")
public class ComplexGatewayImpl extends GatewayImpl implements ComplexGateway
{
  public ComplexGatewayImpl(String name)
  {
    super(name);
  }

  public GatewayType getGatewayType()
  {
    return GatewayType.Complex;
  }

  public Expression getIncommingCondition()
  {
    throw new NotImplementedException("JBPM-1636", "ComplexGateway incomming condition");
  }

  public Expression getOutgoingCondition()
  {
    throw new NotImplementedException("JBPM-1637", "ComplexGateway outgoing condition");
  }

  @Override
  protected void defaultFlowHandler(TokenExecutor tokenExecutor, Token token)
  {
    throw new NotImplementedException("JBPM-1637", "ComplexGateway outgoing condition");
  }

  public String toString()
  {
    return "ComplexGateway[" + getName() + "]";
  }
}