/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.dialect.xpdl21;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import javax.xml.bind.JAXBException;
import org.jboss.bpm.InvalidProcessException;
import org.jboss.bpm.NotImplementedException;
import org.jboss.bpm.client.DialectHandler;
import org.jboss.bpm.dialect.xpdl21.ProcessUnmarshaller;
import org.jboss.bpm.dialect.xpdl21.WorkflowProcessAdapter;
import org.jboss.bpm.dialect.xpdl21.model.XPDLWorkflowProcess;
import org.jboss.bpm.model.Process;

public class DialectHandlerImpl
implements DialectHandler {
    public static final String NAMESPACE_URI = "http://www.wfmc.org/2008/XPDL2.1";

    public String getNamespaceURI() {
        return NAMESPACE_URI;
    }

    public Process createProcess(String pXML, boolean isInclude) {
        try {
            ProcessUnmarshaller unmarschaller = new ProcessUnmarshaller();
            XPDLWorkflowProcess jaxbProc = unmarschaller.unmarshallProcess(new StringReader(pXML));
            Process proc = new WorkflowProcessAdapter().adaptWorkflowProcess(jaxbProc);
            return proc;
        }
        catch (JAXBException ex) {
            throw new InvalidProcessException("Cannot unmarschall: " + pXML, (Throwable)ex);
        }
    }

    public Process createProcess(URL pURL, boolean isInclude) throws IOException {
        try {
            ProcessUnmarshaller unmarschaller = new ProcessUnmarshaller();
            XPDLWorkflowProcess jaxbProc = unmarschaller.unmarshallProcess(new InputStreamReader(pURL.openStream()));
            Process proc = new WorkflowProcessAdapter().adaptWorkflowProcess(jaxbProc);
            return proc;
        }
        catch (JAXBException ex) {
            throw new InvalidProcessException("Cannot unmarschall: " + pURL, (Throwable)ex);
        }
    }

    public void marshallProcess(Process proc, Writer out) throws IOException {
        throw new NotImplementedException("JBPM-1640", "DialectHandler XPL2.1 marshallProcess");
    }
}

