/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.dialect.xpdl21;

// $Id: DialectHandlerImpl.java 1907 2008-08-16 09:20:28Z thomas.diesler@jboss.com $

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;

import javax.xml.bind.JAXBException;

import org.jboss.bpm.InvalidProcessException;
import org.jboss.bpm.NotImplementedException;
import org.jboss.bpm.client.DialectHandler;
import org.jboss.bpm.dialect.xpdl21.model.XPDLWorkflowProcess;
import org.jboss.bpm.model.Process;

/**
 * The DialectHandler converts a supported dialect to the internal Process model.
 * 
 * @author thomas.diesler@jboss.com
 * @since 18-Jun-2008
 */
public class DialectHandlerImpl implements DialectHandler
{
  public static final String NAMESPACE_URI = "http://www.wfmc.org/2008/XPDL2.1";

  public String getNamespaceURI()
  {
    return NAMESPACE_URI;
  }

  public Process createProcess(String pXML, boolean isInclude)
  {
    try
    {
      ProcessUnmarshaller unmarschaller = new ProcessUnmarshaller();
      XPDLWorkflowProcess jaxbProc = unmarschaller.unmarshallProcess(new StringReader(pXML));
      Process proc = new WorkflowProcessAdapter().adaptWorkflowProcess(jaxbProc);
      return proc;
    }
    catch (JAXBException ex)
    {
      throw new InvalidProcessException("Cannot unmarschall: " + pXML, ex);
    }
  }

  public Process createProcess(URL pURL, boolean isInclude) throws IOException
  {
    try
    {
      ProcessUnmarshaller unmarschaller = new ProcessUnmarshaller();
      XPDLWorkflowProcess jaxbProc = unmarschaller.unmarshallProcess(new InputStreamReader(pURL.openStream()));
      Process proc = new WorkflowProcessAdapter().adaptWorkflowProcess(jaxbProc);
      return proc;
    }
    catch (JAXBException ex)
    {
      throw new InvalidProcessException("Cannot unmarschall: " + pURL, ex);
    }
  }

  public void marshallProcess(Process proc, Writer out) throws IOException
  {
    throw new NotImplementedException("JBPM-1640", "DialectHandler XPL2.1 marshallProcess");
  }
}