/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import org.jbpm.api.Configuration;
import org.jbpm.api.ExecutionService;
import org.jbpm.api.ManagementService;
import org.jbpm.api.NewDeployment;
import org.jbpm.api.ProcessEngine;
import org.jbpm.api.RepositoryService;
import org.jbpm.api.job.Job;

public class BeforeUpgrade {
    private ProcessEngine processEngine = new Configuration().buildProcessEngine();
    private RepositoryService repositoryService = this.processEngine.getRepositoryService();
    private ExecutionService executionService = this.processEngine.getExecutionService();
    private ManagementService managementService = this.processEngine.getManagementService();
    private static final String TEST_PROCESS_1 = "testprocess1.jpdl.xml";
    private static final String TEST_PROCESS_2 = "testprocess2.jpdl.xml";
    private static final String TEST_PROCESS_3 = "testprocess3.jpdl.xml";

    public static void main(String[] args) {
        BeforeUpgrade beforeUpgrade = new BeforeUpgrade();
        beforeUpgrade.generateProcess1Data();
        beforeUpgrade.generateProcess2Data();
        beforeUpgrade.generateProcess3Data();
    }

    private void deploy(String processFile) {
        NewDeployment deployment = this.repositoryService.createDeployment();
        deployment.addResourceFromClasspath(processFile);
        deployment.deploy();
    }

    private void generateProcess1Data() {
        this.deploy(TEST_PROCESS_1);
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            String procDefKey = TEST_PROCESS_1.replace(".jpdl.xml", "");
            String procInstKey = procDefKey + "-" + i;
            ids.add(this.executionService.startProcessInstanceByKey(procDefKey, procInstKey).getId());
        }
        String execId = this.executionService.findProcessInstanceById((String)ids.get(0)).findActiveExecutionIn("send invoice").getId();
        this.executionService.signalExecutionById(execId);
        execId = this.executionService.findProcessInstanceById((String)ids.get(0)).findActiveExecutionIn("load truck").getId();
        this.executionService.signalExecutionById(execId);
        execId = this.executionService.findProcessInstanceById((String)ids.get(1)).findActiveExecutionIn("print documents").getId();
        this.executionService.signalExecutionById(execId);
        this.executionService.endProcessInstance((String)ids.get(2), "ended");
    }

    private void generateProcess2Data() {
        this.deploy(TEST_PROCESS_2);
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < 7; ++i) {
            String procDefKey = TEST_PROCESS_2.replace(".jpdl.xml", "");
            String procInstKey = procDefKey + "-" + i;
            HashMap<String, Integer> vars = new HashMap<String, Integer>();
            vars.put("var", i * 2);
            ids.add(this.executionService.startProcessInstanceByKey(procDefKey, vars, procInstKey).getId());
        }
    }

    private void generateProcess3Data() {
        this.deploy(TEST_PROCESS_3);
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < 2; ++i) {
            String procDefKey = TEST_PROCESS_3.replace(".jpdl.xml", "");
            String procInstKey = procDefKey + "-" + i;
            ids.add(this.executionService.startProcessInstanceByKey(procDefKey, procInstKey).getId());
        }
        Job timer = this.managementService.createJobQuery().processInstanceId((String)ids.get(0)).uniqueResult();
        this.managementService.executeJob(timer.getId());
    }
}

