/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activities;

import java.util.Map;
import org.jbpm.api.Execution;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.activity.ExternalActivityBehaviour;
import org.jbpm.api.model.OpenExecution;
import org.jbpm.pvm.internal.builder.ProcessDefinitionBuilder;
import org.jbpm.pvm.internal.client.ClientProcessInstance;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.test.BaseJbpmTestCase;

public class ScopeVariableTest
extends BaseJbpmTestCase {
    public void testOuterscopeLookup() {
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startActivity("a", (ActivityBehaviour)new WaitState()).initial().transition("b").endActivity().startActivity("b", (ActivityBehaviour)new WaitState()).transition("c").variable("makesSureThisBecomesALocalScope").endActivity().startActivity("c", (ActivityBehaviour)new WaitState()).endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        processInstance.setVariable("destination", (Object)"anywhere");
        processInstance.signal();
        OpenExecution bScope = processInstance.getExecution("b");
        ScopeVariableTest.assertEquals((Object)"anywhere", (Object)bScope.getVariable("destination"));
        bScope.createVariable("temp", (Object)"23C");
        ScopeVariableTest.assertEquals((Object)"23C", (Object)bScope.getVariable("temp"));
        ScopeVariableTest.assertNull((Object)processInstance.getVariable("temp"));
    }

    public void testLocalVariableLookup() {
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startActivity("a", (ActivityBehaviour)new WaitState()).initial().transition("b").endActivity().startActivity("b", (ActivityBehaviour)new WaitState()).transition("c").variable("makesSureThisBecomesALocalScope").endActivity().startActivity("c", (ActivityBehaviour)new WaitState()).endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        processInstance.signal();
        OpenExecution bScope = processInstance.getExecution("b");
        bScope.createVariable("temp", (Object)"23C");
        ScopeVariableTest.assertEquals((Object)"23C", (Object)bScope.getVariable("temp"));
        ScopeVariableTest.assertNull((Object)processInstance.getVariable("temp"));
        processInstance.signal((Execution)bScope);
        ScopeVariableTest.assertTrue((boolean)bScope.isEnded());
        ScopeVariableTest.assertNull((Object)processInstance.getVariable("temp"));
    }

    public void testLocalVariableUpdate() {
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startActivity("a", (ActivityBehaviour)new WaitState()).initial().transition("b").endActivity().startActivity("b", (ActivityBehaviour)new WaitState()).transition("c").variable("makesSureThisBecomesALocalScope").endActivity().startActivity("c", (ActivityBehaviour)new WaitState()).endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        processInstance.signal();
        OpenExecution bScope = processInstance.getExecution("b");
        bScope.createVariable("temp", (Object)"23C");
        bScope.setVariable("temp", (Object)"28C");
        ScopeVariableTest.assertEquals((Object)"28C", (Object)bScope.getVariable("temp"));
        processInstance.signal((Execution)bScope);
        ScopeVariableTest.assertTrue((boolean)bScope.isEnded());
        ScopeVariableTest.assertNull((Object)processInstance.getVariable("temp"));
    }

    public void testDefaultCreationOnGlobalScope() {
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startActivity("a", (ActivityBehaviour)new WaitState()).initial().transition("b").endActivity().startActivity("b", (ActivityBehaviour)new WaitState()).transition("c").variable("makesSureThisBecomesALocalScope").endActivity().startActivity("c", (ActivityBehaviour)new WaitState()).endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        processInstance.signal();
        OpenExecution bScope = processInstance.getExecution("b");
        bScope.setVariable("temp", (Object)"28C");
        ScopeVariableTest.assertEquals((Object)"28C", (Object)bScope.getVariable("temp"));
        processInstance.signal((Execution)bScope);
        ScopeVariableTest.assertTrue((boolean)bScope.isEnded());
        ScopeVariableTest.assertEquals((Object)"28C", (Object)processInstance.getVariable("temp"));
    }

    public void testVariableUpdatesOnEndedScope() {
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startActivity("a", (ActivityBehaviour)new WaitState()).initial().transition("b").endActivity().startActivity("b", (ActivityBehaviour)new WaitState()).transition("c").variable("makesSureThisBecomesALocalScope").endActivity().startActivity("c", (ActivityBehaviour)new WaitState()).endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        processInstance.signal();
        OpenExecution bScope = processInstance.getExecution("b");
        bScope.createVariable("temp", (Object)"28C");
        processInstance.signal((Execution)bScope);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WaitState
    implements ExternalActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) {
            execution.waitForSignal();
        }

        public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) {
            execution.take(signalName);
        }
    }
}

