/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activities;

import java.util.Map;
import junit.framework.TestCase;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.activity.ExternalActivityBehaviour;
import org.jbpm.pvm.internal.builder.ProcessDefinitionBuilder;
import org.jbpm.pvm.internal.client.ClientProcessDefinition;
import org.jbpm.pvm.internal.client.ClientProcessInstance;

public class ExternalDecisionTest
extends TestCase {
    public static ClientProcessDefinition createCreditProcess() {
        return ProcessDefinitionBuilder.startProcess().startActivity("creditRate?", (ActivityBehaviour)new ExternalDecision()).initial().transition("priority delivery", "good").transition("bulk delivery", "average").transition("payment upfront", "bad").endActivity().startActivity("priority delivery", (ActivityBehaviour)new WaitState()).endActivity().startActivity("bulk delivery", (ActivityBehaviour)new WaitState()).endActivity().startActivity("payment upfront", (ActivityBehaviour)new WaitState()).endActivity().endProcess();
    }

    public void testGoodRating() {
        ClientProcessDefinition processDefinition = ExternalDecisionTest.createCreditProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        processInstance.signal("good");
        ExternalDecisionTest.assertTrue((boolean)processInstance.isActive("priority delivery"));
    }

    public void testAverageRating() {
        ClientProcessDefinition processDefinition = ExternalDecisionTest.createCreditProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        processInstance.signal("average");
        ExternalDecisionTest.assertTrue((boolean)processInstance.isActive("bulk delivery"));
    }

    public void testBadRating() {
        ClientProcessDefinition processDefinition = ExternalDecisionTest.createCreditProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        processInstance.signal("bad");
        ExternalDecisionTest.assertTrue((boolean)processInstance.isActive("payment upfront"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WaitState
    implements ExternalActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) {
            execution.waitForSignal();
        }

        public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) {
            execution.take(signalName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExternalDecision
    implements ExternalActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) throws Exception {
            execution.waitForSignal();
        }

        public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) throws Exception {
            execution.take(signalName);
        }
    }
}

