/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activities;

import java.util.Map;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.activity.ExternalActivityBehaviour;
import org.jbpm.pvm.internal.builder.ProcessDefinitionBuilder;
import org.jbpm.pvm.internal.client.ClientProcessDefinition;
import org.jbpm.pvm.internal.client.ClientProcessInstance;
import org.jbpm.test.BaseJbpmTestCase;

public class AutomaticDecisionTest
extends BaseJbpmTestCase {
    public static ClientProcessDefinition createCreditProcess() {
        return ProcessDefinitionBuilder.startProcess().startActivity("creditRate?", (ActivityBehaviour)new AutomaticCreditRating()).initial().transition("priority delivery", "good").transition("bulk delivery", "average").transition("payment upfront", "bad").endActivity().startActivity("priority delivery", (ActivityBehaviour)new WaitState()).endActivity().startActivity("bulk delivery", (ActivityBehaviour)new WaitState()).endActivity().startActivity("payment upfront", (ActivityBehaviour)new WaitState()).endActivity().endProcess();
    }

    public void testGoodRating() {
        ClientProcessDefinition processDefinition = AutomaticDecisionTest.createCreditProcess();
        ClientProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.setVariable("creditRate", (Object)7);
        processInstance.start();
        AutomaticDecisionTest.assertTrue((boolean)processInstance.isActive("priority delivery"));
    }

    public void testAverageRating() {
        ClientProcessDefinition processDefinition = AutomaticDecisionTest.createCreditProcess();
        ClientProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.setVariable("creditRate", (Object)2);
        processInstance.start();
        AutomaticDecisionTest.assertTrue((boolean)processInstance.isActive("bulk delivery"));
    }

    public void testBadRating() {
        ClientProcessDefinition processDefinition = AutomaticDecisionTest.createCreditProcess();
        ClientProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.setVariable("creditRate", (Object)-7);
        processInstance.start();
        AutomaticDecisionTest.assertTrue((boolean)processInstance.isActive("payment upfront"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WaitState
    implements ExternalActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) {
            execution.waitForSignal();
        }

        public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) {
            execution.take(signalName);
        }
    }

    public static class AutomaticCreditRating
    implements ActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) {
            int creditRate = (Integer)execution.getVariable("creditRate");
            if (creditRate > 5) {
                execution.take("good");
            } else if (creditRate < -5) {
                execution.take("bad");
            } else {
                execution.take("average");
            }
        }
    }
}

