/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activities;

import java.util.Map;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.activity.ExternalActivityBehaviour;
import org.jbpm.pvm.internal.builder.ProcessDefinitionBuilder;
import org.jbpm.pvm.internal.client.ClientProcessDefinition;
import org.jbpm.pvm.internal.client.ClientProcessInstance;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.test.BaseJbpmTestCase;

public class SubProcessTest
extends BaseJbpmTestCase {
    public void testSubProcess() {
        ProcessDefinitionImpl subProcess = ProcessDefinitionBuilder.startProcess((String)"sub").startActivity("sub1", (ActivityBehaviour)new AutomaticActivity()).initial().transition("sub2").endActivity().startActivity("sub2", (ActivityBehaviour)new WaitState()).transition("sub3").endActivity().startActivity("sub3", (ActivityBehaviour)new EndState()).endActivity().endProcess();
        ProcessDefinitionImpl superProcess = ProcessDefinitionBuilder.startProcess((String)"super").startActivity("super1", (ActivityBehaviour)new AutomaticActivity()).initial().transition("super2").endActivity().startActivity("super2", (ActivityBehaviour)new SubProcess((ClientProcessDefinition)subProcess)).transition("super3").endActivity().startActivity("super3", (ActivityBehaviour)new WaitState()).endActivity().endProcess();
        ClientProcessInstance superProcessInstance = superProcess.startProcessInstance();
        SubProcessTest.assertTrue((boolean)superProcessInstance.isActive("super2"));
        ClientProcessInstance subProcessInstance = (ClientProcessInstance)superProcessInstance.getSubProcessInstance();
        SubProcessTest.assertNotNull((Object)subProcessInstance);
        SubProcessTest.assertTrue((boolean)subProcessInstance.isActive("sub2"));
        subProcessInstance.signal();
        SubProcessTest.assertTrue((boolean)subProcessInstance.isEnded());
        SubProcessTest.assertTrue((boolean)superProcessInstance.isActive("super3"));
    }

    public static class EndState
    implements ActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) throws Exception {
            execution.end();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WaitState
    implements ExternalActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) {
            execution.waitForSignal();
        }

        public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) {
        }
    }

    public static class AutomaticActivity
    implements ActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SubProcess
    implements ExternalActivityBehaviour {
        private static final long serialVersionUID = 1L;
        ClientProcessDefinition subProcess;

        public SubProcess(ClientProcessDefinition subProcess) {
            this.subProcess = subProcess;
        }

        public void execute(ActivityExecution execution) throws Exception {
            ExecutionImpl executionImpl = (ExecutionImpl)execution;
            ClientProcessInstance subProcessInstance = executionImpl.startSubProcessInstance(this.subProcess);
            if (!subProcessInstance.isEnded()) {
                execution.waitForSignal();
            }
        }

        public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) throws Exception {
        }
    }
}

