/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activities;

import java.util.HashMap;
import java.util.Map;
import org.jbpm.api.Execution;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.activity.ExternalActivityBehaviour;
import org.jbpm.api.model.OpenExecution;
import org.jbpm.pvm.internal.builder.ProcessDefinitionBuilder;
import org.jbpm.pvm.internal.client.ClientProcessInstance;
import org.jbpm.pvm.internal.model.Activity;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.descriptor.StringDescriptor;
import org.jbpm.test.BaseJbpmTestCase;

public class ScopeVariableDeclarationTest
extends BaseJbpmTestCase {
    public void testProcessInstanceVariableDeclaration() {
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().variable("flight").startActivity("a", (ActivityBehaviour)new WaitState()).initial().endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        ScopeVariableDeclarationTest.assertTrue((boolean)processInstance.hasVariable("flight"));
        ScopeVariableDeclarationTest.assertNull((Object)processInstance.getVariable("flight"));
    }

    public void testProcessInstanceVariableDeclarationWithInitialValue() {
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startVariable("flight").initialValue((Descriptor)new StringDescriptor("B52")).endVariable().startActivity("a", (ActivityBehaviour)new WaitState()).initial().endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        ScopeVariableDeclarationTest.assertTrue((boolean)processInstance.hasVariable("flight"));
        ScopeVariableDeclarationTest.assertEquals((Object)"B52", (Object)processInstance.getVariable("flight"));
    }

    public void testNestedScopeDeclarations() {
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startVariable("flight").initialValue((Descriptor)new StringDescriptor("B52")).endVariable().startActivity("outer", (ActivityBehaviour)new Composite()).startVariable("duration").initialValue((Descriptor)new StringDescriptor("22 minutes")).endVariable().startActivity("middle", (ActivityBehaviour)new Composite()).startVariable("altitude").initialValue((Descriptor)new StringDescriptor("31000 ft")).endVariable().startActivity("inner", (ActivityBehaviour)new Composite()).startVariable("passengers").initialValue((Descriptor)new StringDescriptor("52")).endVariable().startActivity("start", (ActivityBehaviour)new WaitState()).initial().startVariable("fuel").initialValue((Descriptor)new StringDescriptor("kerosine")).endVariable().endActivity().endActivity().endActivity().endActivity().endProcess();
        HashMap<String, String> expectedVariables = new HashMap<String, String>();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        expectedVariables.put("flight", "B52");
        ScopeVariableDeclarationTest.assertEquals(expectedVariables, (Object)processInstance.getVariables());
        OpenExecution outerExecution = processInstance.getExecution("outer");
        expectedVariables.put("duration", "22 minutes");
        ScopeVariableDeclarationTest.assertEquals(expectedVariables, (Object)outerExecution.getVariables());
        OpenExecution middleExecution = outerExecution.getExecution("middle");
        expectedVariables.put("altitude", "31000 ft");
        ScopeVariableDeclarationTest.assertEquals(expectedVariables, (Object)middleExecution.getVariables());
        OpenExecution innerExecution = middleExecution.getExecution("inner");
        expectedVariables.put("passengers", "52");
        ScopeVariableDeclarationTest.assertEquals(expectedVariables, (Object)innerExecution.getVariables());
        OpenExecution startExecution = innerExecution.getExecution("start");
        expectedVariables.put("fuel", "kerosine");
        ScopeVariableDeclarationTest.assertEquals(expectedVariables, (Object)startExecution.getVariables());
    }

    public void testHiddenVariable() {
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startVariable("flight").initialValue((Descriptor)new StringDescriptor("B52")).endVariable().startActivity("c", (ActivityBehaviour)new Composite()).startVariable("flight").initialValue((Descriptor)new StringDescriptor("U2")).endVariable().startActivity("i", (ActivityBehaviour)new WaitState()).initial().startVariable("flight").initialValue((Descriptor)new StringDescriptor("C130")).endVariable().endActivity().endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        OpenExecution executionC = processInstance.getExecution("c");
        OpenExecution executionI = executionC.getExecution("i");
        ScopeVariableDeclarationTest.assertEquals((Object)"B52", (Object)processInstance.getVariable("flight"));
        ScopeVariableDeclarationTest.assertEquals((Object)"U2", (Object)executionC.getVariable("flight"));
        ScopeVariableDeclarationTest.assertEquals((Object)"C130", (Object)executionI.getVariable("flight"));
    }

    public void testAutomaticScopeManagement() {
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess().startVariable("flight").initialValue((Descriptor)new StringDescriptor("B52")).endVariable().startActivity("outer", (ActivityBehaviour)new Composite()).startVariable("duration").initialValue((Descriptor)new StringDescriptor("22 minutes")).endVariable().startActivity("left-middle", (ActivityBehaviour)new Composite()).startVariable("altitude").initialValue((Descriptor)new StringDescriptor("31000 ft")).endVariable().startActivity("left-inner", (ActivityBehaviour)new Composite()).startVariable("passengers").initialValue((Descriptor)new StringDescriptor("52")).endVariable().startActivity("left-start", (ActivityBehaviour)new WaitState()).initial().transition("right-inner").startVariable("fuel").initialValue((Descriptor)new StringDescriptor("kerosine")).endVariable().endActivity().endActivity().endActivity().startActivity("right-middle", (ActivityBehaviour)new Composite()).startVariable("customer").initialValue((Descriptor)new StringDescriptor("coca-cola")).endVariable().startActivity("right-inner", (ActivityBehaviour)new WaitState()).startVariable("date").initialValue((Descriptor)new StringDescriptor("today")).endVariable().endActivity().endActivity().endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        OpenExecution outerExecution = processInstance.getExecution("outer");
        OpenExecution leftMiddleExecution = outerExecution.getExecution("left-middle");
        OpenExecution leftInnerExecution = leftMiddleExecution.getExecution("left-inner");
        OpenExecution leftStartExecution = leftInnerExecution.getExecution("left-start");
        HashMap<String, String> expectedVariables = new HashMap<String, String>();
        expectedVariables.put("flight", "B52");
        expectedVariables.put("duration", "22 minutes");
        expectedVariables.put("altitude", "31000 ft");
        expectedVariables.put("passengers", "52");
        expectedVariables.put("fuel", "kerosine");
        ScopeVariableDeclarationTest.assertEquals(expectedVariables, (Object)leftStartExecution.getVariables());
        processInstance.signal((Execution)leftStartExecution);
        OpenExecution rightMiddleExecution = outerExecution.getExecution("right-middle");
        OpenExecution rightInnerExecution = rightMiddleExecution.getExecution("right-inner");
        expectedVariables = new HashMap();
        expectedVariables.put("flight", "B52");
        expectedVariables.put("duration", "22 minutes");
        ScopeVariableDeclarationTest.assertEquals(expectedVariables, (Object)outerExecution.getVariables());
        expectedVariables.put("customer", "coca-cola");
        ScopeVariableDeclarationTest.assertEquals(expectedVariables, (Object)rightMiddleExecution.getVariables());
        expectedVariables.put("date", "today");
        ScopeVariableDeclarationTest.assertEquals(expectedVariables, (Object)rightInnerExecution.getVariables());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Composite
    implements ExternalActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) {
            this.execute((ExecutionImpl)execution);
        }

        public void execute(ExecutionImpl execution) {
            Activity child = (Activity)execution.getActivity().getActivities().get(0);
            execution.execute(child);
        }

        public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WaitState
    implements ExternalActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) {
            execution.waitForSignal();
        }

        public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) {
            execution.take(signalName);
        }
    }
}

