/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activities;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.activity.ExternalActivityBehaviour;
import org.jbpm.pvm.internal.builder.ProcessDefinitionBuilder;
import org.jbpm.pvm.internal.client.ClientProcessInstance;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.test.BaseJbpmTestCase;

public class BasicExecutionFlowTest
extends BaseJbpmTestCase {
    public void testChainOfAutomaticActivitiesAndWaitStates() {
        ArrayList<String> recordedEvents = new ArrayList<String>();
        AutomaticActivity automaticActivity = new AutomaticActivity(recordedEvents);
        WaitState waitState = new WaitState(recordedEvents);
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess((String)"loan").startActivity("submit loan request", (ActivityBehaviour)automaticActivity).initial().transition("evaluate").endActivity().startActivity("evaluate", (ActivityBehaviour)waitState).transition("wire money", "approve").transition("end", "reject").endActivity().startActivity("wire money", (ActivityBehaviour)automaticActivity).transition("archive").endActivity().startActivity("archive", (ActivityBehaviour)waitState).transition("end").endActivity().startActivity("end", (ActivityBehaviour)waitState).endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.startProcessInstance();
        ArrayList<String> expectedEvents = new ArrayList<String>();
        expectedEvents.add("execute[submit loan request]");
        expectedEvents.add("execute[evaluate]");
        BasicExecutionFlowTest.assertTrue((boolean)processInstance.isActive("evaluate"));
        BasicExecutionFlowTest.assertEquals(expectedEvents, recordedEvents);
        processInstance.signal("approve");
        expectedEvents.add("signal[evaluate]");
        expectedEvents.add("execute[wire money]");
        expectedEvents.add("execute[archive]");
        BasicExecutionFlowTest.assertTrue((boolean)processInstance.isActive("archive"));
        BasicExecutionFlowTest.assertEquals(expectedEvents, recordedEvents);
        processInstance.signal();
        expectedEvents.add("signal[archive]");
        expectedEvents.add("execute[end]");
        BasicExecutionFlowTest.assertTrue((boolean)processInstance.isActive("end"));
        BasicExecutionFlowTest.assertEquals(expectedEvents, recordedEvents);
    }

    public void testDelayedBegin() {
        ArrayList<String> recordedEvents = new ArrayList<String>();
        AutomaticActivity automaticActivity = new AutomaticActivity(recordedEvents);
        WaitState waitState = new WaitState(recordedEvents);
        ProcessDefinitionImpl processDefinition = ProcessDefinitionBuilder.startProcess((String)"loan").startActivity("submit loan request", (ActivityBehaviour)automaticActivity).initial().transition("evaluate").endActivity().startActivity("evaluate", (ActivityBehaviour)waitState).transition("wire money", "approve").transition("end", "reject").endActivity().startActivity("wire money", (ActivityBehaviour)automaticActivity).transition("archive").endActivity().startActivity("archive", (ActivityBehaviour)waitState).transition("end").endActivity().startActivity("end", (ActivityBehaviour)waitState).endActivity().endProcess();
        ClientProcessInstance processInstance = processDefinition.createProcessInstance();
        ArrayList<String> expectedEvents = new ArrayList<String>();
        BasicExecutionFlowTest.assertEquals(expectedEvents, recordedEvents);
        processInstance.start();
        expectedEvents.add("execute[submit loan request]");
        expectedEvents.add("execute[evaluate]");
        BasicExecutionFlowTest.assertTrue((boolean)processInstance.isActive("evaluate"));
        BasicExecutionFlowTest.assertEquals(expectedEvents, recordedEvents);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WaitState
    implements ExternalActivityBehaviour {
        private static final long serialVersionUID = 1L;
        List<String> events;

        public WaitState(List<String> events) {
            this.events = events;
        }

        public void execute(ActivityExecution execution) {
            this.events.add("execute[" + execution.getActivityName() + "]");
            execution.waitForSignal();
        }

        public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) throws Exception {
            this.events.add("signal[" + execution.getActivityName() + "]");
            execution.take(signalName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AutomaticActivity
    implements ActivityBehaviour {
        private static final long serialVersionUID = 1L;
        List<String> events;

        public AutomaticActivity(List<String> events) {
            this.events = events;
        }

        public void execute(ActivityExecution execution) {
            this.events.add("execute[" + execution.getActivityName() + "]");
        }
    }
}

