/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.common.wrapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.jboss.tools.flow.common.model.Element;
import org.jboss.tools.flow.common.wrapper.ModelEvent;
import org.jboss.tools.flow.common.wrapper.ModelListener;
import org.jboss.tools.flow.common.wrapper.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWrapper
implements Wrapper {
    private Element element;
    private transient List<ModelListener> listeners = new ArrayList<ModelListener>();
    private Map<Object, List<Element>> children = new HashMap<Object, List<Element>>();

    @Override
    public void setElement(Element element) {
        this.element = element;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public void addChild(Object type, Element element) {
        this.localAddChild(type, element);
        this.internalAddChild(type, element);
        this.notifyListeners(6, type, this, null, element);
    }

    protected void internalAddChild(Object type, Element element) {
        Object childList = this.getPropertyValue(type);
        if (childList == null || !(childList instanceof List)) {
            return;
        }
        ((List)childList).add(element);
    }

    public void localAddChild(Object type, Element element) {
        List<Element> childList = this.children.get(type);
        if (childList == null) {
            childList = new ArrayList<Element>();
            this.children.put(type, childList);
        }
        childList.add(element);
    }

    @Override
    public void removeChild(Object type, Element element) {
        this.localRemoveChild(type, element);
        this.internalRemoveChild(type, element);
        this.notifyListeners(7, type, this, element, null);
    }

    protected void internalRemoveChild(Object type, Element element) {
        Object childList = this.getPropertyValue(type);
        if (childList == null || !(childList instanceof List)) {
            return;
        }
        ((List)childList).remove(element);
    }

    public void localRemoveChild(Object type, Element element) {
        List<Element> childList = this.children.get(type);
        if (childList == null) {
            return;
        }
        childList.remove(element);
        if (childList.isEmpty()) {
            this.children.remove(type);
        }
    }

    @Override
    public List<Element> getChildren(Object type) {
        return this.children.get(type);
    }

    @Override
    public void setMetaData(String name, Object value) {
        if (this.element != null) {
            this.element.setMetaData(name, value);
        }
    }

    @Override
    public Object getMetaData(String name) {
        if (this.element != null) {
            return this.element.getMetaData(name);
        }
        return null;
    }

    @Override
    public void addListener(ModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void notifyListeners(int type, Object discriminator, Object object, Object oldValue, Object newValue) {
        this.notifyListeners(new ModelEvent(type, discriminator, object, oldValue, newValue));
    }

    public void notifyListeners(ModelEvent event) {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).modelChanged(event);
            ++i;
        }
    }

    public void notifyListeners(int change) {
        this.notifyListeners(change, null, null, null, null);
    }

    public Object getEditableValue() {
        if (this.getPropertySource() != null) {
            this.getPropertySource().getEditableValue();
        }
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.getPropertySource() != null) {
            return this.getPropertySource().getPropertyDescriptors();
        }
        return null;
    }

    public Object getPropertyValue(Object id) {
        if (this.getPropertySource() != null) {
            return this.getPropertySource().getPropertyValue(id);
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        if (this.getPropertySource() != null) {
            return this.getPropertySource().isPropertySet(id);
        }
        return false;
    }

    public void resetPropertyValue(Object id) {
        if (this.getPropertySource() != null) {
            this.getPropertySource().resetPropertyValue(id);
        }
    }

    public void setPropertyValue(Object id, Object newValue) {
        if (this.getPropertySource() != null) {
            Object oldValue = this.getPropertySource().getPropertyValue(id);
            this.getPropertySource().setPropertyValue(id, newValue);
            this.notifyListeners(8, id, this, oldValue, newValue);
        }
    }

    protected abstract IPropertySource getPropertySource();

    public Object getAdapter(Class adapter) {
        if (adapter == Element.class) {
            return this.element;
        }
        if (adapter == IPropertySource.class) {
            return this.getPropertySource();
        }
        return null;
    }
}

