/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.common.registry;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.requests.CreationFactory;
import org.jboss.tools.flow.common.Logger;
import org.jboss.tools.flow.common.model.Connection;
import org.jboss.tools.flow.common.model.Container;
import org.jboss.tools.flow.common.model.Element;
import org.jboss.tools.flow.common.model.Flow;
import org.jboss.tools.flow.common.model.Node;
import org.jboss.tools.flow.common.strategy.AcceptsElementStrategy;
import org.jboss.tools.flow.common.strategy.AcceptsIncomingConnectionStrategy;
import org.jboss.tools.flow.common.strategy.AcceptsOutgoingConnectionStrategy;
import org.jboss.tools.flow.common.wrapper.DefaultConnectionWrapper;
import org.jboss.tools.flow.common.wrapper.DefaultContainerWrapper;
import org.jboss.tools.flow.common.wrapper.DefaultFlowWrapper;
import org.jboss.tools.flow.common.wrapper.DefaultLabelWrapper;
import org.jboss.tools.flow.common.wrapper.DefaultNodeWrapper;
import org.jboss.tools.flow.common.wrapper.DefaultWrapper;
import org.jboss.tools.flow.common.wrapper.Wrapper;

public class ElementRegistry {
    private static final String elementsExtensionPointId = "org.jboss.tools.flow.common.elements";
    private static HashMap<String, IConfigurationElement> elementMap = null;

    private static void initializeRegistry() {
        IConfigurationElement[] configurationElements;
        elementMap = new HashMap();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(elementsExtensionPointId);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            elementMap.put(configurationElement.getAttribute("id"), configurationElement);
            ++n2;
        }
    }

    private static Wrapper createWrapper(IConfigurationElement configurationElement) throws CoreException {
        IConfigurationElement[] children = configurationElement.getChildren();
        if (children.length > 1) {
            return null;
        }
        if (children.length == 0) {
            return ElementRegistry.createDefault(configurationElement);
        }
        String type = children[0].getName();
        if ("flow".equals(type)) {
            return ElementRegistry.createFlow(configurationElement);
        }
        if ("container".equals(type)) {
            return ElementRegistry.createContainer(configurationElement);
        }
        if ("node".equals(type)) {
            return ElementRegistry.createNode(configurationElement);
        }
        if ("connection".equals(type)) {
            return ElementRegistry.createConnection(configurationElement);
        }
        return null;
    }

    private static Wrapper createDefault(IConfigurationElement configurationElement) throws CoreException {
        Object element = configurationElement.createExecutableExtension("class");
        if (!(element instanceof Element)) {
            String message = "Expecting to instantiate a org.jboss.tools.flow.common.model.Element instance.";
            Logger.logError(message, new RuntimeException(message));
            return null;
        }
        ((Element)element).setMetaData("configurationElement", configurationElement);
        DefaultWrapper result = new DefaultWrapper();
        result.setElement((Element)element);
        return result;
    }

    private static Wrapper createConnection(IConfigurationElement configurationElement) throws CoreException {
        Object element = configurationElement.createExecutableExtension("class");
        if (!(element instanceof Connection)) {
            String message = "Expecting to instantiate a org.jboss.tools.flow.common.model.Connection instance.";
            Logger.logError(message, new RuntimeException(message));
            return null;
        }
        ((Element)element).setMetaData("configurationElement", configurationElement);
        DefaultConnectionWrapper result = new DefaultConnectionWrapper();
        result.setElement((Element)element);
        result.setLabel(new DefaultLabelWrapper(result));
        return result;
    }

    private static Wrapper createNode(IConfigurationElement configurationElement) throws CoreException {
        AcceptsOutgoingConnectionStrategy acceptsOutgoingConnectionStrategy;
        Object element = configurationElement.createExecutableExtension("class");
        if (!(element instanceof Node)) {
            String message = "Expecting to instantiate a org.jboss.tools.flow.common.model.Node instance.";
            Logger.logError(message, new RuntimeException(message));
            return null;
        }
        ((Node)element).setMetaData("configurationElement", configurationElement);
        DefaultNodeWrapper result = new DefaultNodeWrapper();
        result.setElement((Element)element);
        AcceptsIncomingConnectionStrategy acceptsIncomingConnectionStrategy = ElementRegistry.createAcceptsIncomingConnectionStrategy(configurationElement);
        if (acceptsIncomingConnectionStrategy != null) {
            acceptsIncomingConnectionStrategy.setNode((Node)element);
            result.setAcceptsIncomingConnectionStrategy(acceptsIncomingConnectionStrategy);
        }
        if ((acceptsOutgoingConnectionStrategy = ElementRegistry.createAcceptsOutgoingConnectionStrategy(configurationElement)) != null) {
            acceptsOutgoingConnectionStrategy.setNode((Node)element);
            result.setAcceptsOutgoingConnectionStrategy(acceptsOutgoingConnectionStrategy);
        }
        ((Node)element).setName(configurationElement.getAttribute("name"));
        return result;
    }

    private static Wrapper createContainer(IConfigurationElement configurationElement) throws CoreException {
        AcceptsOutgoingConnectionStrategy acceptsOutgoingConnectionStrategy;
        AcceptsIncomingConnectionStrategy acceptsIncomingConnectionStrategy;
        Object element = configurationElement.createExecutableExtension("class");
        if (!(element instanceof Container)) {
            String message = "Expecting to instantiate a org.jboss.tools.flow.common.model.Container instance.";
            Logger.logError(message, new RuntimeException(message));
            return null;
        }
        ((Element)element).setMetaData("configurationElement", configurationElement);
        DefaultContainerWrapper result = new DefaultContainerWrapper();
        result.setElement((Element)element);
        AcceptsElementStrategy acceptsElementStrategy = ElementRegistry.createAcceptsElementStrategy(configurationElement);
        if (acceptsElementStrategy != null) {
            acceptsElementStrategy.setContainer((Container)element);
            result.setAcceptsElementStrategy(acceptsElementStrategy);
        }
        if ((acceptsIncomingConnectionStrategy = ElementRegistry.createAcceptsIncomingConnectionStrategy(configurationElement)) != null) {
            acceptsIncomingConnectionStrategy.setNode((Node)element);
            result.setAcceptsIncomingConnectionStrategy(acceptsIncomingConnectionStrategy);
        }
        if ((acceptsOutgoingConnectionStrategy = ElementRegistry.createAcceptsOutgoingConnectionStrategy(configurationElement)) != null) {
            acceptsOutgoingConnectionStrategy.setNode((Node)element);
            result.setAcceptsOutgoingConnectionStrategy(acceptsOutgoingConnectionStrategy);
        }
        if (element instanceof Node) {
            ((Node)element).setName(configurationElement.getAttribute("name"));
        }
        return result;
    }

    private static AcceptsIncomingConnectionStrategy createAcceptsIncomingConnectionStrategy(IConfigurationElement configurationElement) throws CoreException {
        Object result = null;
        IConfigurationElement[] children = configurationElement.getChildren();
        if (children[0].getAttribute("acceptsIncomingConnectionStrategy") != null) {
            result = children[0].createExecutableExtension("acceptsIncomingConnectionStrategy");
        }
        return (AcceptsIncomingConnectionStrategy)result;
    }

    private static AcceptsOutgoingConnectionStrategy createAcceptsOutgoingConnectionStrategy(IConfigurationElement configurationElement) throws CoreException {
        Object result = null;
        IConfigurationElement[] children = configurationElement.getChildren();
        if (children[0].getAttribute("acceptsOutgoingConnectionStrategy") != null) {
            result = children[0].createExecutableExtension("acceptsOutgoingConnectionStrategy");
        }
        return (AcceptsOutgoingConnectionStrategy)result;
    }

    private static AcceptsElementStrategy createAcceptsElementStrategy(IConfigurationElement configurationElement) throws CoreException {
        Object result = null;
        IConfigurationElement[] children = configurationElement.getChildren();
        if (children[0].getAttribute("acceptsElementStrategy") != null) {
            result = children[0].createExecutableExtension("acceptsElementStrategy");
        }
        return (AcceptsElementStrategy)result;
    }

    private static Wrapper createFlow(IConfigurationElement configurationElement) throws CoreException {
        Object element = configurationElement.createExecutableExtension("class");
        if (!(element instanceof Container)) {
            String message = "Expecting to instantiate a org.jboss.tools.flow.common.model.Container instance.";
            Logger.logError(message, new RuntimeException(message));
            return null;
        }
        ((Element)element).setMetaData("configurationElement", configurationElement);
        DefaultFlowWrapper result = new DefaultFlowWrapper();
        result.setElement((Element)element);
        AcceptsElementStrategy acceptsElementStrategy = ElementRegistry.createAcceptsElementStrategy(configurationElement);
        if (acceptsElementStrategy != null) {
            acceptsElementStrategy.setContainer((Container)result.getElement());
            result.setAcceptsElementStrategy(acceptsElementStrategy);
        }
        if (element instanceof Flow) {
            ((Flow)element).setName(configurationElement.getAttribute("name"));
        }
        return result;
    }

    public static Wrapper createWrapper(String elementId) {
        IConfigurationElement configurationElement;
        if (elementMap == null) {
            ElementRegistry.initializeRegistry();
        }
        if ((configurationElement = elementMap.get(elementId)) != null) {
            try {
                return ElementRegistry.createWrapper(configurationElement);
            }
            catch (CoreException e) {
                Logger.logError("Creating a wrapper for " + elementId + " failed.", e);
                return null;
            }
        }
        return null;
    }

    public static IConfigurationElement getConfigurationElement(String elementId) {
        return elementMap.get(elementId);
    }

    public static CreationFactory getCreationFactory(final String elementId) {
        return new CreationFactory(){

            public Object getNewObject() {
                return ElementRegistry.createWrapper(elementId);
            }

            public Object getObjectType() {
                return elementId;
            }
        };
    }

    public static CreationFactory getCreationFactory(Element element) {
        String id = null;
        IConfigurationElement configurationElement = (IConfigurationElement)element.getMetaData("configurationElement");
        if (configurationElement != null) {
            id = configurationElement.getAttribute("id");
        }
        return id == null ? null : ElementRegistry.getCreationFactory(id);
    }
}

