/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.common.properties;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.jboss.tools.flow.common.wrapper.Wrapper;

public class WrapperPropertySource
implements IPropertySource {
    private Wrapper wrapper;
    private IPropertySource elementPropertySource;

    public WrapperPropertySource(Wrapper wrapper) {
        Object object;
        this.wrapper = wrapper;
        if (wrapper != null && wrapper.getElement() != null && (object = wrapper.getElement().getMetaData("propertySource")) != null && object instanceof IPropertySource) {
            this.elementPropertySource = (IPropertySource)object;
        }
    }

    public Object getEditableValue() {
        if (this.elementPropertySource != null) {
            return this.elementPropertySource.getEditableValue();
        }
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.elementPropertySource != null) {
            return this.elementPropertySource.getPropertyDescriptors();
        }
        return new IPropertyDescriptor[0];
    }

    public Object getPropertyValue(Object id) {
        if (this.elementPropertySource != null) {
            return this.elementPropertySource.getPropertyValue(id);
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        if (this.elementPropertySource != null) {
            return this.elementPropertySource.isPropertySet(id);
        }
        return false;
    }

    public void resetPropertyValue(Object id) {
        if (this.elementPropertySource != null) {
            this.elementPropertySource.resetPropertyValue(id);
        }
    }

    public void setPropertyValue(Object id, Object newValue) {
        if (this.elementPropertySource != null) {
            Object oldValue = this.elementPropertySource.getPropertyValue(id);
            this.elementPropertySource.setPropertyValue(id, newValue);
            this.wrapper.notifyListeners(8, id, this.wrapper, oldValue, newValue);
        }
    }

    protected Wrapper getWrapper() {
        return this.wrapper;
    }

    protected IPropertyDescriptor[] merge(IPropertyDescriptor[] first, IPropertyDescriptor[] second) {
        IPropertyDescriptor[] result = new IPropertyDescriptor[first.length + second.length];
        int i = 0;
        while (i < first.length) {
            result[i] = first[i];
            ++i;
        }
        i = first.length;
        while (i < result.length) {
            result[i] = second[i - first.length];
            ++i;
        }
        return result;
    }
}

