/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.common.figure;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.jboss.tools.flow.common.figure.AbstractElementFigure;
import org.jboss.tools.flow.common.figure.DiamondAnchor;

public class DiamondElementFigure
extends AbstractElementFigure {
    protected Polygon diamond;

    protected void customizeFigure() {
        this.diamond = new Polygon();
        this.diamond.setLineWidth(1);
        this.add((IFigure)this.diamond, 0);
        this.setSize(50, 50);
        this.diamond.setPoints(this.calculatePointList());
    }

    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        this.diamond.setPoints(this.calculatePointList());
    }

    private PointList calculatePointList() {
        PointList result = new PointList();
        Rectangle bounds = this.getBounds();
        result.addPoint(bounds.x + bounds.width / 2 - this.diamond.getLineWidth() / 4, bounds.y + this.diamond.getLineWidth() / 2);
        result.addPoint(bounds.x + bounds.width - this.diamond.getLineWidth(), bounds.y + bounds.height / 2 - this.diamond.getLineWidth() / 4);
        result.addPoint(bounds.x + bounds.width / 2 - this.diamond.getLineWidth() / 4, bounds.y + bounds.height - this.diamond.getLineWidth());
        result.addPoint(bounds.x + this.diamond.getLineWidth() / 2, bounds.y + bounds.height / 2 - this.diamond.getLineWidth() / 4);
        return result;
    }

    public ConnectionAnchor getSourceConnectionAnchor() {
        return new DiamondAnchor(this);
    }

    public ConnectionAnchor getTargetConnectionAnchor() {
        return new DiamondAnchor(this);
    }
}

