/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.common.editor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EventObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.ToggleGridAction;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.jboss.tools.flow.common.Activator;
import org.jboss.tools.flow.common.action.HorizontalAutoLayoutAction;
import org.jboss.tools.flow.common.action.VerticalAutoLayoutAction;
import org.jboss.tools.flow.common.editor.GenericContextMenuProvider;
import org.jboss.tools.flow.common.editor.OverviewOutlinePage;
import org.jboss.tools.flow.common.editpart.EditPartFactory;
import org.jboss.tools.flow.common.registry.LanguageRegistry;

public abstract class GenericModelEditor
extends GraphicalEditorWithPalette {
    private Object model;
    private boolean savePreviouslyNeeded = false;
    private KeyHandler sharedKeyHandler;
    private PaletteRoot root;
    private OverviewOutlinePage overviewOutlinePage;
    private String language;

    public GenericModelEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    protected void setModel(Object model) {
        this.model = model;
    }

    public Object getModel() {
        return this.model;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.initializeEditDomain();
        this.initializeLanguage();
    }

    protected void initializeEditDomain() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.getCommandStack().addCommandStackListener((CommandStackListener)this);
    }

    protected void initializeLanguage() {
        this.language = LanguageRegistry.getLanguageRegisteredFor(this.getSite().getId());
    }

    public String getLanguage() {
        return this.language;
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        DirectEditAction action = new DirectEditAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 1);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 2);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 4);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 8);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 16);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 32);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
    }

    public void commandStackChanged(EventObject event) {
        if (this.isDirty()) {
            if (!this.savePreviouslyNeeded()) {
                this.setSavePreviouslyNeeded(true);
                this.firePropertyChange(257);
            }
        } else {
            this.setSavePreviouslyNeeded(false);
            this.firePropertyChange(257);
        }
        super.commandStackChanged(event);
    }

    protected abstract void writeModel(OutputStream var1) throws IOException;

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.getGraphicalViewer().setRootEditPart((RootEditPart)new ScalableRootEditPart());
        this.getGraphicalViewer().setEditPartFactory(this.createEditPartFactory());
        this.getGraphicalViewer().setKeyHandler(new GraphicalViewerKeyHandler(this.getGraphicalViewer()).setParent(this.getCommonKeyHandler()));
        ToggleGridAction showGrid = new ToggleGridAction(this.getGraphicalViewer());
        this.getActionRegistry().registerAction((IAction)showGrid);
        VerticalAutoLayoutAction layoutVertically = new VerticalAutoLayoutAction(this.getGraphicalViewer());
        this.getActionRegistry().registerAction((IAction)layoutVertically);
        HorizontalAutoLayoutAction layoutHorizontally = new HorizontalAutoLayoutAction(this.getGraphicalViewer());
        this.getActionRegistry().registerAction((IAction)layoutHorizontally);
        GenericContextMenuProvider provider = new GenericContextMenuProvider(this.getGraphicalViewer(), this.getActionRegistry());
        this.getGraphicalViewer().setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("org.jboss.tools.flow.editor.contextmenu", (MenuManager)provider, (ISelectionProvider)this.getGraphicalViewer());
    }

    protected org.eclipse.gef.EditPartFactory createEditPartFactory() {
        return new EditPartFactory();
    }

    protected void initializeGraphicalViewer() {
        this.getGraphicalViewer().setContents(this.model);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.writeModel(out);
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            file.setContents((InputStream)new ByteArrayInputStream(out.toByteArray()), true, false, monitor);
            out.close();
            this.getCommandStack().markSaveLocation();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doSaveAs() {
        SaveAsDialog dialog = new SaveAsDialog(this.getSite().getWorkbenchWindow().getShell());
        dialog.setOriginalFile(((IFileEditorInput)this.getEditorInput()).getFile());
        dialog.open();
        IPath path = dialog.getResult();
        if (path == null) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IFile file = workspace.getRoot().getFile(path);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    GenericModelEditor.this.writeModel(out);
                    file.create((InputStream)new ByteArrayInputStream(out.toByteArray()), true, monitor);
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getWorkbenchWindow().getShell()).run(false, true, (IRunnableWithProgress)op);
            this.setInput((IEditorInput)new FileEditorInput(file));
            this.getCommandStack().markSaveLocation();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.sharedKeyHandler;
    }

    public boolean isDirty() {
        return this.isSaveOnCloseNeeded();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.getCommandStack().isDirty();
    }

    private boolean savePreviouslyNeeded() {
        return this.savePreviouslyNeeded;
    }

    private void setSavePreviouslyNeeded(boolean value) {
        this.savePreviouslyNeeded = value;
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.root == null) {
            this.root = this.createPalette();
        }
        return this.root;
    }

    protected abstract PaletteRoot createPalette();

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        IFile file = this.getFile();
        this.setPartName(file.getName());
        try {
            InputStream is = file.getContents(false);
            this.createModel(is);
        }
        catch (Throwable t) {
            Activator.log(t);
        }
        if (this.getGraphicalViewer() != null) {
            this.initializeGraphicalViewer();
        }
    }

    public IFile getFile() {
        return ((IFileEditorInput)this.getEditorInput()).getFile();
    }

    public IProject getProject() {
        IFile file = this.getFile();
        if (file != null) {
            return file.getProject();
        }
        return null;
    }

    protected abstract void createModel(InputStream var1);

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            return this.getOverviewOutlinePage();
        }
        if (type == ZoomManager.class) {
            return ((ScalableRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        return super.getAdapter(type);
    }

    protected OverviewOutlinePage getOverviewOutlinePage() {
        if (this.overviewOutlinePage == null && this.getGraphicalViewer() != null) {
            ScalableRootEditPart rootEditPart = (ScalableRootEditPart)this.getGraphicalViewer().getRootEditPart();
            this.overviewOutlinePage = new OverviewOutlinePage(rootEditPart);
        }
        return this.overviewOutlinePage;
    }

    public void createImage(OutputStream stream, int format) {
        SWTGraphics g = null;
        GC gc = null;
        Image image = null;
        LayerManager layerManager = (LayerManager)this.getGraphicalViewer().getEditPartRegistry().get(LayerManager.ID);
        IFigure figure = layerManager.getLayer((Object)"Printable Layers");
        Rectangle r = figure.getBounds();
        try {
            try {
                image = new Image((Device)Display.getDefault(), r.width, r.height);
                gc = new GC((Drawable)image);
                g = new SWTGraphics(gc);
                g.translate(r.x * -1, r.y * -1);
                figure.paint((Graphics)g);
                ImageLoader imageLoader = new ImageLoader();
                imageLoader.data = new ImageData[]{image.getImageData()};
                imageLoader.save(stream, format);
            }
            catch (Throwable t) {
                Activator.log(t);
                if (g != null) {
                    g.dispose();
                }
                if (gc != null) {
                    gc.dispose();
                }
                if (image != null) {
                    image.dispose();
                }
            }
        }
        finally {
            if (g != null) {
                g.dispose();
            }
            if (gc != null) {
                gc.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
    }
}

