/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.common.command;

import org.eclipse.gef.commands.Command;
import org.jboss.tools.flow.common.wrapper.ConnectionWrapper;
import org.jboss.tools.flow.common.wrapper.NodeWrapper;

public class ElementConnectionCreateCommand
extends Command {
    private ConnectionWrapper connection;
    private NodeWrapper source;
    private NodeWrapper target;

    public boolean canExecute() {
        if (this.source.equals(this.target)) {
            return false;
        }
        for (ConnectionWrapper connection : this.source.getOutgoingConnections()) {
            if (!connection.getTarget().equals(this.target)) continue;
            return false;
        }
        return this.source.acceptsOutgoingConnection(this.connection, this.target) && this.target != null && this.target.acceptsIncomingConnection(this.connection, this.source);
    }

    public void execute() {
        this.connection.connect(this.source, this.target);
    }

    public NodeWrapper getSource() {
        return this.source;
    }

    public NodeWrapper getTarget() {
        return this.target;
    }

    public void redo() {
        this.connection.connect(this.source, this.target);
    }

    public void setSource(NodeWrapper source) {
        this.source = source;
    }

    public void setConnection(ConnectionWrapper connection) {
        this.connection = connection;
    }

    public void setTarget(NodeWrapper target) {
        this.target = target;
    }

    public void undo() {
        this.connection.disconnect();
    }
}

