/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.jpdl4.properties;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jboss.tools.flow.jpdl4.command.ChangePropertyCommand;
import org.jboss.tools.flow.jpdl4.properties.JpdlPropertySheetPage;

public abstract class JpdlPropertySection
extends AbstractPropertySection {
    public static final int SECOND_COLUMN_LEFT_LIMIT = 30;
    private CommandStack commandStack;
    private Composite flatFormComposite;
    private IPropertySource input;

    protected abstract void hookListeners();

    protected abstract void updateValues();

    protected abstract void unhookListeners();

    protected CommandStack getCommandStack() {
        return this.commandStack;
    }

    protected Composite getFlatFormComposite() {
        return this.flatFormComposite;
    }

    protected String getValueNullsAllowed(String string) {
        return "".equals(string) ? null : string;
    }

    protected String getValueNotNull(String string) {
        return string == null ? "" : string;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        if (aTabbedPropertySheetPage instanceof JpdlPropertySheetPage) {
            this.commandStack = ((JpdlPropertySheetPage)aTabbedPropertySheetPage).getCommandStack();
        }
        this.flatFormComposite = this.getWidgetFactory().createFlatFormComposite(parent);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        Object object;
        super.setInput(part, selection);
        if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable && (object = ((IAdaptable)object).getAdapter(IPropertySource.class)) instanceof IPropertySource) {
            this.input = (IPropertySource)object;
            return;
        }
        this.input = null;
    }

    public IPropertySource getInput() {
        return this.input;
    }

    protected void changeProperty(Object propertyId, Object newValue) {
        if (this.commandStack == null || this.input == null) {
            return;
        }
        Object oldValue = this.input.getPropertyValue(propertyId);
        if (oldValue == newValue) {
            return;
        }
        ChangePropertyCommand changePropertyCommand = new ChangePropertyCommand();
        changePropertyCommand.setPropertyId(propertyId);
        changePropertyCommand.setTarget(this.input);
        changePropertyCommand.setNewValue(newValue);
        this.commandStack.execute((Command)changePropertyCommand);
    }

    public void aboutToBeShown() {
        this.refresh();
    }

    public void refresh() {
        this.unhookListeners();
        this.updateValues();
        this.hookListeners();
    }
}

