/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.jpdl4.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.jboss.tools.flow.common.model.DefaultFlow;
import org.jboss.tools.flow.common.model.Element;
import org.jboss.tools.flow.common.model.Node;
import org.jboss.tools.flow.jpdl4.model.EventListenerContainer;
import org.jboss.tools.flow.jpdl4.model.StartEvent;
import org.jboss.tools.flow.jpdl4.model.Swimlane;
import org.jboss.tools.flow.jpdl4.model.Timer;
import org.jboss.tools.flow.jpdl4.util.Jpdl4Helper;

public class Process
extends DefaultFlow {
    public static final String KEY = "key";
    public static final String VERSION = "version";
    public static final String DESCRIPTION = "description";
    private Node initial = null;
    private String key;
    private String version;
    private String description;
    private List<Swimlane> swimlanes = new ArrayList<Swimlane>();
    private List<Timer> timers = new ArrayList<Timer>();
    private List<EventListenerContainer> eventlisteners = new ArrayList<EventListenerContainer>();

    public Process() {
        this.setMetaData("propertySource", new PropertySource());
    }

    public StartEvent getStartState() {
        for (Node node : this.getNodes()) {
            if (!(node instanceof StartEvent)) continue;
            return (StartEvent)node;
        }
        return null;
    }

    public Node getInitial() {
        return this.initial;
    }

    public void setInitial(Node node) {
        this.initial = node;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void removeNode(Node node) {
        Jpdl4Helper.mergeLeadingNodes((Element)node);
        super.removeNode(node);
    }

    private class PropertySource
    implements IPropertySource {
        private PropertySource() {
        }

        public Object getEditableValue() {
            return null;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return new IPropertyDescriptor[0];
        }

        public Object getPropertyValue(Object id) {
            if ("swimlane".equals(id)) {
                return Process.this.swimlanes;
            }
            if ("timer".equals(id)) {
                return Process.this.timers;
            }
            if ("eventListener".equals(id)) {
                return Process.this.eventlisteners;
            }
            if (Process.KEY.equals(id)) {
                return Process.this.getKey();
            }
            if (Process.VERSION.equals(id)) {
                return Process.this.getVersion();
            }
            if (Process.DESCRIPTION.equals(id)) {
                return Process.this.getDescription();
            }
            return null;
        }

        public boolean isPropertySet(Object id) {
            if ("swimlane".equals(id)) {
                return true;
            }
            if ("timer".equals(id)) {
                return true;
            }
            if ("eventListener".equals(id)) {
                return true;
            }
            if (Process.KEY.equals(id)) {
                return Process.this.getKey() != null;
            }
            if (Process.VERSION.equals(id)) {
                return Process.this.getVersion() != null;
            }
            if (Process.DESCRIPTION.equals(id)) {
                return Process.this.getDescription() != null;
            }
            return false;
        }

        public void resetPropertyValue(Object id) {
        }

        public void setPropertyValue(Object id, Object value) {
            if (Process.KEY.equals(id)) {
                Process.this.setKey((String)value);
            } else if (Process.VERSION.equals(id)) {
                Process.this.setVersion((String)value);
            } else if (Process.DESCRIPTION.equals(id)) {
                Process.this.setDescription((String)value);
            }
        }
    }
}

