/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.jpdl4.editor;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.jboss.tools.flow.common.model.Element;
import org.jboss.tools.flow.common.wrapper.ConnectionWrapper;
import org.jboss.tools.flow.common.wrapper.ContainerWrapper;
import org.jboss.tools.flow.common.wrapper.FlowWrapper;
import org.jboss.tools.flow.common.wrapper.LabelWrapper;
import org.jboss.tools.flow.common.wrapper.NodeWrapper;
import org.jboss.tools.flow.common.wrapper.Wrapper;
import org.jboss.tools.flow.jpdl4.Logger;
import org.jboss.tools.flow.jpdl4.model.Argument;
import org.jboss.tools.flow.jpdl4.model.CancelEndEvent;
import org.jboss.tools.flow.jpdl4.model.CustomTask;
import org.jboss.tools.flow.jpdl4.model.ErrorEndEvent;
import org.jboss.tools.flow.jpdl4.model.EventListener;
import org.jboss.tools.flow.jpdl4.model.EventListenerContainer;
import org.jboss.tools.flow.jpdl4.model.ExclusiveGateway;
import org.jboss.tools.flow.jpdl4.model.Field;
import org.jboss.tools.flow.jpdl4.model.ForkParallelGateway;
import org.jboss.tools.flow.jpdl4.model.HqlTask;
import org.jboss.tools.flow.jpdl4.model.HumanTask;
import org.jboss.tools.flow.jpdl4.model.InputParameter;
import org.jboss.tools.flow.jpdl4.model.JavaTask;
import org.jboss.tools.flow.jpdl4.model.JoinParallelGateway;
import org.jboss.tools.flow.jpdl4.model.MailTask;
import org.jboss.tools.flow.jpdl4.model.OutputParameter;
import org.jboss.tools.flow.jpdl4.model.Parameter;
import org.jboss.tools.flow.jpdl4.model.Process;
import org.jboss.tools.flow.jpdl4.model.ProcessNode;
import org.jboss.tools.flow.jpdl4.model.ScriptTask;
import org.jboss.tools.flow.jpdl4.model.SequenceFlow;
import org.jboss.tools.flow.jpdl4.model.ServiceTask;
import org.jboss.tools.flow.jpdl4.model.SqlTask;
import org.jboss.tools.flow.jpdl4.model.StartEvent;
import org.jboss.tools.flow.jpdl4.model.SubprocessTask;
import org.jboss.tools.flow.jpdl4.model.SuperState;
import org.jboss.tools.flow.jpdl4.model.Swimlane;
import org.jboss.tools.flow.jpdl4.model.TerminateEndEvent;
import org.jboss.tools.flow.jpdl4.model.Timer;
import org.jboss.tools.flow.jpdl4.model.WaitTask;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpdlSerializer {
    private static TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private static Transformer transformer = null;

    static {
        try {
            transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        catch (TransformerConfigurationException e) {
            Logger.logError("Error while creating XML tranformer.", e);
        }
    }

    public void serialize(Wrapper wrapper, OutputStream os) throws IOException {
        StringBuffer buffer = new StringBuffer();
        this.appendToBuffer(buffer, wrapper, 0);
        OutputStreamWriter writer = new OutputStreamWriter(os);
        writer.write(buffer.toString());
        ((Writer)writer).close();
    }

    private void appendToBuffer(StringBuffer buffer, Wrapper wrapper, int level) {
        Element object = wrapper.getElement();
        if (!(object instanceof Element)) {
            return;
        }
        this.appendOpening(buffer, wrapper, level);
        StringBuffer body = new StringBuffer();
        this.appendBody(body, wrapper, level);
        if (body.length() > 0) {
            buffer.append(">");
            buffer.append(body);
            this.appendClosing(buffer, wrapper, level);
        } else {
            buffer.append("/>");
        }
    }

    private void appendNodeList(StringBuffer buffer, ArrayList<Node> nodeList) {
        if (transformer == null) {
            Logger.logInfo("Skipping append nodes as transformer is not initialized.");
            return;
        }
        DOMSource domSource = new DOMSource();
        for (Node node : nodeList) {
            StringWriter writer = new StringWriter();
            domSource.setNode(node);
            StreamResult result = new StreamResult(writer);
            try {
                transformer.transform(domSource, result);
            }
            catch (TransformerException e) {
                Logger.logError("Exception while transforming xml.", e);
            }
            buffer.append(writer.getBuffer());
        }
    }

    private String getNodeName(Element element) {
        IConfigurationElement configuration = (IConfigurationElement)element.getMetaData("configurationElement");
        String elementId = configuration.getAttribute("id");
        if ("org.jboss.tools.flow.jpdl4.process".equals(elementId)) {
            return "process";
        }
        if ("org.jboss.tools.flow.jpdl4.startEvent".equals(elementId)) {
            return "start";
        }
        if ("org.jboss.tools.flow.jpdl4.terminateEndEvent".equals(elementId)) {
            return "end";
        }
        if ("org.jboss.tools.flow.jpdl4.errorEndEvent".equals(elementId)) {
            return "end-error";
        }
        if ("org.jboss.tools.flow.jpdl4.cancelEndEvent".equals(elementId)) {
            return "end-cancel";
        }
        if ("org.jboss.tools.flow.jpdl4.waitTask".equals(elementId)) {
            return "state";
        }
        if ("org.jboss.tools.flow.jpdl4.hqlTask".equals(elementId)) {
            return "hql";
        }
        if ("org.jboss.tools.flow.jpdl4.sqlTask".equals(elementId)) {
            return "sql";
        }
        if ("org.jboss.tools.flow.jpdl4.javaTask".equals(elementId)) {
            return "java";
        }
        if ("org.jboss.tools.flow.jpdl4.scriptTask".equals(elementId)) {
            return "script";
        }
        if ("org.jboss.tools.flow.jpdl4.mailTask".equals(elementId)) {
            return "mail";
        }
        if ("org.jboss.tools.flow.jpdl4.serviceTask".equals(elementId)) {
            return "esb";
        }
        if ("org.jboss.tools.flow.jpdl4.humanTask".equals(elementId)) {
            return "task";
        }
        if ("org.jboss.tools.flow.jpdl4.subprocessTask".equals(elementId)) {
            return "sub-process";
        }
        if ("org.jboss.tools.flow.jpdl4.customTask".equals(elementId)) {
            return "custom";
        }
        if ("org.jboss.tools.flow.jpdl4.exclusiveGateway".equals(elementId)) {
            return "decision";
        }
        if ("org.jboss.tools.flow.jpdl4.parallelJoinGateway".equals(elementId)) {
            return "join";
        }
        if ("org.jboss.tools.flow.jpdl4.parallelForkGateway".equals(elementId)) {
            return "fork";
        }
        if ("org.jboss.tools.flow.jpdl4.sequenceFlow".equals(elementId)) {
            return "transition";
        }
        if ("org.jboss.tools.flow.jpdl4.swimlane".equals(elementId)) {
            return "swimlane";
        }
        if ("org.jboss.tools.flow.jpdl4.timer".equals(elementId)) {
            return "timer";
        }
        if ("org.jboss.tools.flow.jpdl4.eventListenerContainer".equals(elementId)) {
            return "on";
        }
        if ("org.jboss.tools.flow.jpdl4.eventListener".equals(elementId)) {
            return "event-listener";
        }
        if ("org.jboss.tools.flow.jpdl4.inputParameter".equals(elementId)) {
            return "parameter-in";
        }
        if ("org.jboss.tools.flow.jpdl4.outputParameter".equals(elementId)) {
            return "parameter-out";
        }
        if ("org.jboss.tools.flow.jpdl4.argument".equals(elementId)) {
            return "arg";
        }
        if ("org.jboss.tools.flow.jpdl4.field".equals(elementId)) {
            return "field";
        }
        return null;
    }

    private void appendOpening(StringBuffer buffer, Wrapper wrapper, int level) {
        Element element = wrapper.getElement();
        if (element instanceof SequenceFlow) {
            new SequenceFlowWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof TerminateEndEvent) {
            new TerminateEndEventWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof ErrorEndEvent) {
            new ProcessNodeWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof CancelEndEvent) {
            new ProcessNodeWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof StartEvent) {
            new ProcessNodeWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof SuperState) {
            new ProcessNodeWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof WaitTask) {
            new ProcessNodeWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof HqlTask) {
            new ProcessNodeWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof SqlTask) {
            new ProcessNodeWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof JavaTask) {
            new JavaTaskWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof ScriptTask) {
            new ScriptTaskWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof MailTask) {
            new ProcessNodeWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof ServiceTask) {
            new ProcessNodeWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof HumanTask) {
            new HumanTaskWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof SubprocessTask) {
            new SubprocessTaskWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof CustomTask) {
            new ProcessNodeWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof ExclusiveGateway) {
            new ExclusiveGatewayWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof ForkParallelGateway) {
            new ProcessNodeWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof JoinParallelGateway) {
            new ProcessNodeWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof Process) {
            new ProcessWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof Swimlane) {
            new SwimlaneWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof Timer) {
            new TimerWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof EventListenerContainer) {
            new EventListenerContainerWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof EventListener) {
            new EventListenerWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof Parameter) {
            new ParameterWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof Argument) {
            new ArgumentWrapperSerializer().appendOpening(buffer, wrapper, level);
        } else if (element instanceof Field) {
            new FieldWrapperSerializer().appendOpening(buffer, wrapper, level);
        }
    }

    private void appendBody(StringBuffer buffer, Wrapper wrapper, int level) {
        boolean appendTrailingNodes;
        Element element = wrapper.getElement();
        if (element instanceof SequenceFlow) {
            new SequenceFlowWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof TerminateEndEvent) {
            new TerminateEndEventWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof ErrorEndEvent) {
            new ProcessNodeWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof CancelEndEvent) {
            new ProcessNodeWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof StartEvent) {
            new ProcessNodeWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof SuperState) {
            new ProcessNodeWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof WaitTask) {
            new ProcessNodeWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof HqlTask) {
            new ProcessNodeWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof SqlTask) {
            new ProcessNodeWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof JavaTask) {
            new JavaTaskWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof ScriptTask) {
            new ScriptTaskWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof MailTask) {
            new ProcessNodeWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof ServiceTask) {
            new ProcessNodeWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof HumanTask) {
            new HumanTaskWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof SubprocessTask) {
            new SubprocessTaskWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof CustomTask) {
            new ProcessNodeWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof ExclusiveGateway) {
            new ExclusiveGatewayWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof ForkParallelGateway) {
            new ProcessNodeWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof JoinParallelGateway) {
            new ProcessNodeWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof Process) {
            new ProcessWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof Swimlane) {
            new SwimlaneWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof Timer) {
            new TimerWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof EventListenerContainer) {
            new EventListenerContainerWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof EventListener) {
            new EventListenerWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof Argument) {
            new ArgumentWrapperSerializer().appendBody(buffer, wrapper, level);
        } else if (element instanceof Field) {
            new FieldWrapperSerializer().appendBody(buffer, wrapper, level);
        }
        ArrayList trailingNodeList = (ArrayList)element.getMetaData("trailingNodes");
        boolean bl = appendTrailingNodes = trailingNodeList != null && !trailingNodeList.isEmpty();
        if (appendTrailingNodes) {
            this.appendNodeList(buffer, trailingNodeList);
        } else if (buffer.length() > 0) {
            buffer.append("\n");
            this.appendPadding(buffer, level);
        }
    }

    private void appendPadding(StringBuffer buffer, int level) {
        int i = 0;
        while (i < level) {
            buffer.append("   ");
            ++i;
        }
    }

    private void appendClosing(StringBuffer buffer, Wrapper wrapper, int level) {
        Element element = wrapper.getElement();
        if (element instanceof SequenceFlow) {
            buffer.append("</transition>");
        } else if (element instanceof TerminateEndEvent) {
            buffer.append("</end>");
        } else if (element instanceof ErrorEndEvent) {
            buffer.append("</end-error>");
        } else if (element instanceof CancelEndEvent) {
            buffer.append("</end-cancel>");
        } else if (element instanceof StartEvent) {
            buffer.append("</start>");
        } else if (element instanceof SuperState) {
            buffer.append("</super-state>");
        } else if (element instanceof WaitTask) {
            buffer.append("</state>");
        } else if (element instanceof HqlTask) {
            buffer.append("</hql>");
        } else if (element instanceof SqlTask) {
            buffer.append("</sql>");
        } else if (element instanceof JavaTask) {
            buffer.append("</java>");
        } else if (element instanceof ScriptTask) {
            buffer.append("</script>");
        } else if (element instanceof MailTask) {
            buffer.append("</mail>");
        } else if (element instanceof ServiceTask) {
            buffer.append("</esb>");
        } else if (element instanceof HumanTask) {
            buffer.append("</task>");
        } else if (element instanceof SubprocessTask) {
            buffer.append("</sub-process>");
        } else if (element instanceof CustomTask) {
            buffer.append("</custom>");
        } else if (element instanceof ExclusiveGateway) {
            buffer.append("</decision>");
        } else if (element instanceof ForkParallelGateway) {
            buffer.append("</fork>");
        } else if (element instanceof JoinParallelGateway) {
            buffer.append("</join>");
        } else if (element instanceof Process) {
            buffer.append("</process>");
        } else if (element instanceof Swimlane) {
            buffer.append("</swimlane>");
        } else if (element instanceof Timer) {
            buffer.append("</timer>");
        } else if (element instanceof EventListenerContainer) {
            buffer.append("</on>");
        } else if (element instanceof EventListener) {
            buffer.append("</event-listener>");
        } else if (element instanceof InputParameter) {
            buffer.append("</parameter-in>");
        } else if (element instanceof OutputParameter) {
            buffer.append("</parameter-out>");
        } else if (element instanceof Argument) {
            buffer.append("</arg>");
        } else if (element instanceof Field) {
            buffer.append("</field>");
        }
    }

    private boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AbstractWrapperSerializer
    implements WrapperSerializer {
        AbstractWrapperSerializer() {
        }

        protected abstract List<String> getAttributesToSave();

        protected String getPropertyName(String attributeName) {
            return attributeName;
        }

        protected void appendAttributeToSave(String attributeName, StringBuffer buffer, Wrapper wrapper) {
            String value = (String)wrapper.getPropertyValue((Object)this.getPropertyName(attributeName));
            if (value == null || "".equals(value)) {
                return;
            }
            buffer.append(" " + attributeName + "=\"" + value + "\"");
        }

        protected void appendLeadingNodes(StringBuffer buffer, Wrapper wrapper, int level) {
            boolean appendLeadingNodes;
            ArrayList leadingNodeList = (ArrayList)wrapper.getElement().getMetaData("leadingNodes");
            boolean bl = appendLeadingNodes = leadingNodeList != null && !leadingNodeList.isEmpty();
            if (appendLeadingNodes) {
                JpdlSerializer.this.appendNodeList(buffer, leadingNodeList);
            } else {
                buffer.append("\n");
                JpdlSerializer.this.appendPadding(buffer, level);
            }
        }

        protected void appendDefaultAttribute(StringBuffer buffer, Node node) {
            buffer.append(" " + node.getNodeName() + "=\"" + node.getNodeValue() + "\"");
        }

        protected void appendAttributes(StringBuffer buffer, Wrapper wrapper, int level) {
            int i;
            Element element = wrapper.getElement();
            if (element == null) {
                return;
            }
            NamedNodeMap attributes = (NamedNodeMap)element.getMetaData("attributes");
            List<String> attributeNames = this.getAttributesToSave();
            if (attributes != null) {
                i = 0;
                while (i < attributes.getLength()) {
                    String nodeName = attributes.item(i).getNodeName();
                    if (attributeNames.contains(nodeName)) {
                        this.appendAttributeToSave(nodeName, buffer, wrapper);
                        attributeNames.remove(nodeName);
                    } else {
                        this.appendDefaultAttribute(buffer, attributes.item(i));
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < attributeNames.size()) {
                this.appendAttributeToSave(attributeNames.get(i), buffer, wrapper);
                ++i;
            }
        }

        @Override
        public void appendOpening(StringBuffer buffer, Wrapper wrapper, int level) {
            this.appendLeadingNodes(buffer, wrapper, level);
            buffer.append("<" + JpdlSerializer.this.getNodeName(wrapper.getElement()));
            this.appendAttributes(buffer, wrapper, level);
        }

        public void appendClosing(StringBuffer buffer, Wrapper wrapper) {
            buffer.append("</" + JpdlSerializer.this.getNodeName(wrapper.getElement()) + ">");
        }

        public void appendBody(StringBuffer buffer, Wrapper wrapper, int level) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ArgumentWrapperSerializer
    extends AbstractWrapperSerializer {
        ArgumentWrapperSerializer() {
        }

        @Override
        protected List<String> getAttributesToSave() {
            ArrayList<String> result = new ArrayList<String>();
            return result;
        }

        @Override
        public void appendBody(StringBuffer buffer, Wrapper wrapper, int level) {
            String value = (String)wrapper.getPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.argument.value");
            if (value != null && !"".equals(value)) {
                buffer.append("\n");
                JpdlSerializer.this.appendPadding(buffer, level + 1);
                buffer.append("<string value=\"" + value + "\"/>");
            }
            super.appendBody(buffer, wrapper, level);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EventListenerContainerWrapperSerializer
    extends AbstractWrapperSerializer {
        EventListenerContainerWrapperSerializer() {
        }

        @Override
        protected List<String> getAttributesToSave() {
            ArrayList<String> result = new ArrayList<String>();
            result.add("event");
            return result;
        }

        @Override
        protected String getPropertyName(String attributeName) {
            if ("event".equals(attributeName)) {
                return "org.jboss.tools.flow.jpdl4.model.eventListenerContainer.eventType";
            }
            return super.getPropertyName(attributeName);
        }

        @Override
        public void appendBody(StringBuffer buffer, Wrapper wrapper, int level) {
            List eventListeners;
            EventListenerContainer eventListenerContainer = (EventListenerContainer)wrapper.getElement();
            String dueDate = eventListenerContainer.getDueDate();
            String repeat = eventListenerContainer.getRepeat();
            if (dueDate != null && !"".equals(dueDate) || repeat != null && !"".equals(repeat)) {
                buffer.append("\n");
                JpdlSerializer.this.appendPadding(buffer, level);
                buffer.append("<timer");
                if (dueDate != null && !"".equals(dueDate)) {
                    buffer.append(" duedate=\"" + dueDate + "\"");
                }
                if (repeat != null && !"".equals(repeat)) {
                    buffer.append(" repeat=\"" + repeat + "\"");
                }
                buffer.append("/>");
            }
            if ((eventListeners = wrapper.getChildren((Object)"org.jboss.tools.flow.jpdl4.model.eventListenerContainer.listeners")) != null) {
                for (Element eventListener : eventListeners) {
                    if (!(eventListener instanceof Wrapper)) continue;
                    JpdlSerializer.this.appendToBuffer(buffer, (Wrapper)eventListener, level + 1);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EventListenerWrapperSerializer
    extends AbstractWrapperSerializer {
        EventListenerWrapperSerializer() {
        }

        @Override
        protected List<String> getAttributesToSave() {
            ArrayList<String> result = new ArrayList<String>();
            result.add("class");
            return result;
        }

        @Override
        protected String getPropertyName(String attributeName) {
            if ("class".equals(attributeName)) {
                return "org.jboss.tools.flow.jpdl4.model.eventListener.className";
            }
            return super.getPropertyName(attributeName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ExclusiveGatewayWrapperSerializer
    extends ProcessNodeWrapperSerializer {
        ExclusiveGatewayWrapperSerializer() {
        }

        @Override
        protected List<String> getAttributesToSave() {
            List<String> result = super.getAttributesToSave();
            result.add("expr");
            result.add("lang");
            return result;
        }

        @Override
        public void appendBody(StringBuffer buffer, Wrapper wrapper, int level) {
            ExclusiveGateway exclusiveGateway = (ExclusiveGateway)wrapper.getElement();
            String handler = exclusiveGateway.getHandler();
            if (handler != null && !"".equals(handler)) {
                buffer.append("\n");
                JpdlSerializer.this.appendPadding(buffer, level + 1);
                buffer.append("<handler class=\"" + handler + "\" />");
            }
            super.appendBody(buffer, wrapper, level);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FieldWrapperSerializer
    extends AbstractWrapperSerializer {
        FieldWrapperSerializer() {
        }

        @Override
        protected List<String> getAttributesToSave() {
            ArrayList<String> result = new ArrayList<String>();
            result.add("name");
            return result;
        }

        @Override
        protected String getPropertyName(String attributeName) {
            if ("name".equals(attributeName)) {
                return "org.jboss.tools.flow.jpdl4.model.field.name";
            }
            return super.getPropertyName(attributeName);
        }

        @Override
        public void appendBody(StringBuffer buffer, Wrapper wrapper, int level) {
            String value = (String)wrapper.getPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.field.value");
            if (value != null && !"".equals(value)) {
                buffer.append("\n");
                JpdlSerializer.this.appendPadding(buffer, level + 1);
                buffer.append("<string value=\"" + value + "\"/>");
            }
            super.appendBody(buffer, wrapper, level);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HumanTaskWrapperSerializer
    extends ProcessNodeWrapperSerializer {
        HumanTaskWrapperSerializer() {
        }

        @Override
        protected List<String> getAttributesToSave() {
            List<String> result = super.getAttributesToSave();
            result.add("assignee");
            result.add("candidate-groups");
            result.add("swimlane");
            return result;
        }

        @Override
        protected void appendAttributeToSave(String attributeName, StringBuffer buffer, Wrapper wrapper) {
            if (!(wrapper instanceof NodeWrapper)) {
                return;
            }
            Element element = wrapper.getElement();
            if (!(element instanceof HumanTask)) {
                return;
            }
            if ("assignee".equals(attributeName)) {
                this.appendExpression("assignee", buffer, wrapper);
            } else if ("candidate-groups".equals(attributeName)) {
                this.appendExpression("candidate-groups", buffer, wrapper);
            } else if ("swimlane".equals(attributeName)) {
                this.appendExpression("swimlane", buffer, wrapper);
            } else {
                super.appendAttributeToSave(attributeName, buffer, wrapper);
            }
        }

        protected void appendExpression(String type, StringBuffer buffer, Wrapper wrapper) {
            Object assignmentType = wrapper.getPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.assignment.type");
            if (!(assignmentType instanceof Integer)) {
                return;
            }
            if (type.equals(HumanTask.ASSIGNMENT_TYPES[(Integer)assignmentType])) {
                Object value = wrapper.getPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.assignment.expression");
                if (value == null || "".equals(value)) {
                    return;
                }
                buffer.append(" " + type + "=\"" + value + "\"");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JavaTaskWrapperSerializer
    extends ProcessNodeWrapperSerializer {
        JavaTaskWrapperSerializer() {
        }

        @Override
        protected List<String> getAttributesToSave() {
            List<String> result = super.getAttributesToSave();
            result.add("class");
            result.add("method");
            result.add("var");
            return result;
        }

        @Override
        protected String getPropertyName(String attributeName) {
            if ("class".equals(attributeName)) {
                return "org.jboss.tools.flow.jpdl4.model.javaTask.class";
            }
            if ("method".equals(attributeName)) {
                return "org.jboss.tools.flow.jpdl4.model.javaTask.method";
            }
            if ("var".equals(attributeName)) {
                return "org.jboss.tools.flow.jpdl4.model.javaTask.var";
            }
            return super.getPropertyName(attributeName);
        }

        @Override
        public void appendBody(StringBuffer buffer, Wrapper wrapper, int level) {
            List arguments;
            List fields = wrapper.getChildren((Object)"org.jboss.tools.flow.jpdl4.model.javaTask.fields");
            if (fields != null) {
                for (Element field : fields) {
                    if (!(field instanceof Wrapper)) continue;
                    JpdlSerializer.this.appendToBuffer(buffer, (Wrapper)field, level + 1);
                }
            }
            if ((arguments = wrapper.getChildren((Object)"org.jboss.tools.flow.jpdl4.model.javaTask.args")) != null) {
                for (Element argument : arguments) {
                    if (!(argument instanceof Wrapper)) continue;
                    JpdlSerializer.this.appendToBuffer(buffer, (Wrapper)argument, level + 1);
                }
            }
            super.appendBody(buffer, wrapper, level);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ParameterWrapperSerializer
    extends AbstractWrapperSerializer {
        ParameterWrapperSerializer() {
        }

        @Override
        protected List<String> getAttributesToSave() {
            ArrayList<String> result = new ArrayList<String>();
            result.add("var");
            result.add("subvar");
            result.add("expr");
            result.add("lang");
            return result;
        }

        @Override
        protected String getPropertyName(String attributeName) {
            if ("var".equals(attributeName)) {
                return "org.jboss.tools.flow.jpdl4.model.parameter.var";
            }
            if ("subvar".equals(attributeName)) {
                return "org.jboss.tools.flow.jpdl4.model.parameter.subvar";
            }
            if ("expr".equals(attributeName)) {
                return "org.jboss.tools.flow.jpdl4.model.parameter.expr";
            }
            if ("lang".equals(attributeName)) {
                return "org.jboss.tools.flow.jpdl4.model.parameter.lang";
            }
            return super.getPropertyName(attributeName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProcessNodeWrapperSerializer
    extends AbstractWrapperSerializer {
        ProcessNodeWrapperSerializer() {
        }

        @Override
        protected List<String> getAttributesToSave() {
            ArrayList<String> result = new ArrayList<String>();
            result.add("name");
            result.add("g");
            return result;
        }

        @Override
        protected void appendAttributeToSave(String attributeName, StringBuffer buffer, Wrapper wrapper) {
            if (!(wrapper instanceof NodeWrapper)) {
                return;
            }
            Element element = wrapper.getElement();
            if (!(element instanceof ProcessNode)) {
                return;
            }
            if ("name".equals(attributeName)) {
                this.appendName(buffer, (ProcessNode)element);
            } else if ("g".equals(attributeName)) {
                this.appendGraphics(buffer, (NodeWrapper)wrapper);
            } else {
                super.appendAttributeToSave(attributeName, buffer, wrapper);
            }
        }

        protected void appendName(StringBuffer buffer, ProcessNode processNode) {
            String value = processNode.getName();
            if (value == null || "".equals(value)) {
                return;
            }
            buffer.append(" name=\"" + value + "\"");
        }

        protected void appendGraphics(StringBuffer buffer, NodeWrapper wrapper) {
            Rectangle constraint = wrapper.getConstraint();
            buffer.append(" g=\"");
            buffer.append(constraint.x);
            buffer.append(",");
            buffer.append(constraint.y);
            buffer.append(",");
            buffer.append(constraint.width);
            buffer.append(",");
            buffer.append(constraint.height);
            buffer.append("\"");
        }

        @Override
        public void appendBody(StringBuffer buffer, Wrapper wrapper, int level) {
            NodeWrapper nodeWrapper = (NodeWrapper)wrapper;
            List eventListenerContainers = nodeWrapper.getChildren((Object)"eventListener");
            if (eventListenerContainers != null) {
                for (Element eventListenerContainer : eventListenerContainers) {
                    if (!(eventListenerContainer instanceof Wrapper)) continue;
                    JpdlSerializer.this.appendToBuffer(buffer, (Wrapper)eventListenerContainer, level + 1);
                }
            }
            List children = nodeWrapper.getOutgoingConnections();
            for (ConnectionWrapper connectionWrapper : children) {
                JpdlSerializer.this.appendToBuffer(buffer, (Wrapper)connectionWrapper, level + 1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProcessWrapperSerializer
    extends AbstractWrapperSerializer {
        ProcessWrapperSerializer() {
        }

        @Override
        public void appendOpening(StringBuffer buffer, Wrapper wrapper, int level) {
            buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
            buffer.append("<" + JpdlSerializer.this.getNodeName(wrapper.getElement()));
            this.appendAttributes(buffer, wrapper, level);
        }

        @Override
        protected List<String> getAttributesToSave() {
            ArrayList<String> result = new ArrayList<String>();
            result.add("name");
            result.add("initial");
            result.add("key");
            result.add("version");
            result.add("description");
            return result;
        }

        @Override
        protected void appendAttributeToSave(String attributeName, StringBuffer buffer, Wrapper wrapper) {
            if (!(wrapper instanceof FlowWrapper)) {
                return;
            }
            Element element = wrapper.getElement();
            if (element == null || !(element instanceof Process)) {
                return;
            }
            if ("name".equals(attributeName)) {
                this.appendName(buffer, (Process)element);
            } else if ("key".equals(attributeName)) {
                this.appendKey(buffer, (Process)element);
            } else if ("version".equals(attributeName)) {
                this.appendVersion(buffer, (Process)element);
            } else if ("description".equals(attributeName)) {
                this.appendDescription(buffer, (Process)element);
            } else if ("initial".equals(attributeName)) {
                this.appendInitial(buffer, (Process)element);
            } else {
                super.appendAttributeToSave(attributeName, buffer, wrapper);
            }
        }

        protected void appendName(StringBuffer buffer, Process process) {
            String value = process.getName();
            if (value == null || "".equals(value)) {
                return;
            }
            buffer.append(" name=\"" + value + "\"");
        }

        protected void appendInitial(StringBuffer buffer, Process process) {
            if (process.getInitial() == null) {
                return;
            }
            String value = process.getInitial().getName();
            if (value == null || "".equals(value)) {
                return;
            }
            buffer.append(" initial=\"" + value + "\"");
        }

        protected void appendKey(StringBuffer buffer, Process process) {
            if (process.getKey() == null) {
                return;
            }
            String value = process.getKey();
            if (value == null || "".equals(value)) {
                return;
            }
            buffer.append(" key=\"" + value + "\"");
        }

        protected void appendVersion(StringBuffer buffer, Process process) {
            if (process.getVersion() == null) {
                return;
            }
            String value = process.getVersion();
            if (value == null || "".equals(value)) {
                return;
            }
            buffer.append(" version=\"" + value + "\"");
        }

        protected void appendDescription(StringBuffer buffer, Process process) {
            if (process.getDescription() == null) {
                return;
            }
            String value = process.getDescription();
            if (value == null || "".equals(value)) {
                return;
            }
            buffer.append(" description=\"" + value + "\"");
        }

        @Override
        public void appendBody(StringBuffer buffer, Wrapper wrapper, int level) {
            List eventListenerContainers;
            List timers;
            FlowWrapper flowWrapper = (FlowWrapper)wrapper;
            List swimlanes = flowWrapper.getChildren((Object)"swimlane");
            if (swimlanes != null) {
                for (Element swimlane : swimlanes) {
                    if (!(swimlane instanceof Wrapper)) continue;
                    JpdlSerializer.this.appendToBuffer(buffer, (Wrapper)swimlane, level + 1);
                }
            }
            if ((timers = flowWrapper.getChildren((Object)"timer")) != null) {
                for (Element timer : timers) {
                    if (!(timer instanceof Wrapper)) continue;
                    JpdlSerializer.this.appendToBuffer(buffer, (Wrapper)timer, level + 1);
                }
            }
            if ((eventListenerContainers = flowWrapper.getChildren((Object)"eventListener")) != null) {
                for (Element eventListenerContainer : eventListenerContainers) {
                    if (!(eventListenerContainer instanceof Wrapper)) continue;
                    JpdlSerializer.this.appendToBuffer(buffer, (Wrapper)eventListenerContainer, level + 1);
                }
            }
            ContainerWrapper containerWrapper = (ContainerWrapper)wrapper;
            List children = containerWrapper.getNodeWrappers();
            for (NodeWrapper nodeWrapper : children) {
                JpdlSerializer.this.appendToBuffer(buffer, (Wrapper)nodeWrapper, level + 1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ScriptTaskWrapperSerializer
    extends ProcessNodeWrapperSerializer {
        ScriptTaskWrapperSerializer() {
        }

        @Override
        protected List<String> getAttributesToSave() {
            List<String> result = super.getAttributesToSave();
            result.add("expr");
            result.add("lang");
            result.add("var");
            return result;
        }

        @Override
        protected String getPropertyName(String attributeName) {
            if ("expr".equals(attributeName)) {
                return "org.jboss.tools.flow.jpdl4.model.scriptTask.expr";
            }
            if ("lang".equals(attributeName)) {
                return "org.jboss.tools.flow.jpdl4.model.scriptTask.lang";
            }
            if ("var".equals(attributeName)) {
                return "org.jboss.tools.flow.jpdl4.model.javaTask.var";
            }
            return super.getPropertyName(attributeName);
        }

        @Override
        public void appendBody(StringBuffer buffer, Wrapper wrapper, int level) {
            String text = (String)wrapper.getPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.javaTask.text");
            if (text != null && !"".equals(text)) {
                buffer.append("\n");
                JpdlSerializer.this.appendPadding(buffer, level + 1);
                buffer.append("<text>" + text + "</text>");
            }
            super.appendBody(buffer, wrapper, level);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SequenceFlowWrapperSerializer
    extends AbstractWrapperSerializer {
        SequenceFlowWrapperSerializer() {
        }

        @Override
        protected List<String> getAttributesToSave() {
            ArrayList<String> result = new ArrayList<String>();
            result.add("name");
            result.add("to");
            result.add("g");
            return result;
        }

        @Override
        protected void appendAttributeToSave(String attributeName, StringBuffer buffer, Wrapper wrapper) {
            if (!(wrapper instanceof ConnectionWrapper)) {
                return;
            }
            Element element = wrapper.getElement();
            if (!(element instanceof SequenceFlow)) {
                return;
            }
            if ("name".equals(attributeName)) {
                this.appendName(buffer, (SequenceFlow)element);
            } else if ("to".equals(attributeName)) {
                this.appendTo(buffer, (SequenceFlow)element);
            } else if ("g".equals(attributeName)) {
                this.appendGraphics(buffer, (ConnectionWrapper)wrapper);
            }
        }

        protected void appendName(StringBuffer buffer, SequenceFlow sequenceFlow) {
            if (sequenceFlow.getName() == null) {
                return;
            }
            String value = sequenceFlow.getName();
            if (value == null || "".equals(sequenceFlow.getName())) {
                return;
            }
            buffer.append(" name=\"" + value + "\"");
        }

        protected void appendTo(StringBuffer buffer, SequenceFlow sequenceFlow) {
            if (sequenceFlow.getTo() == null) {
                return;
            }
            String value = sequenceFlow.getTo().getName();
            if (value == null || "".equals(value)) {
                return;
            }
            buffer.append(" to=\"" + value + "\"");
        }

        protected void appendGraphics(StringBuffer buffer, ConnectionWrapper wrapper) {
            Point location;
            StringBuffer bendPointBuffer = new StringBuffer();
            List bendPoints = wrapper.getBendpoints();
            if (bendPoints != null && bendPoints.size() > 0) {
                int i = 0;
                while (i < bendPoints.size()) {
                    bendPointBuffer.append(((Point)bendPoints.get((int)i)).x);
                    bendPointBuffer.append(",");
                    bendPointBuffer.append(((Point)bendPoints.get((int)i)).y);
                    if (i < bendPoints.size() - 1) {
                        bendPointBuffer.append(";");
                    }
                    ++i;
                }
            }
            StringBuffer labelBuffer = new StringBuffer();
            LabelWrapper labelWrapper = wrapper.getLabel();
            if (labelWrapper != null && !JpdlSerializer.this.isEmpty(labelWrapper.getText()) && (location = labelWrapper.getLocation()) != null) {
                labelBuffer.append(location.x);
                labelBuffer.append(',');
                labelBuffer.append(location.y);
            }
            if (bendPointBuffer.length() + labelBuffer.length() == 0) {
                return;
            }
            buffer.append(" g=\"");
            buffer.append(bendPointBuffer);
            if (bendPointBuffer.length() > 0) {
                buffer.append(':');
            }
            buffer.append(labelBuffer);
            buffer.append("\"");
        }

        @Override
        public void appendBody(StringBuffer buffer, Wrapper wrapper, int level) {
            List eventListeners;
            String outcome;
            String timer = (String)wrapper.getPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.sequenceFlow.timer");
            if (timer != null && !"".equals(timer)) {
                buffer.append("\n");
                JpdlSerializer.this.appendPadding(buffer, level + 1);
                buffer.append("<timer duedate=\"" + timer + "\"/>");
            }
            if ((outcome = (String)wrapper.getPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.sequenceFlow.outcome")) != null && !"".equals(outcome)) {
                buffer.append("\n");
                JpdlSerializer.this.appendPadding(buffer, level + 1);
                buffer.append("<outcome-value><string value=\"" + outcome + "\"/></outcome-value>");
            }
            if ((eventListeners = wrapper.getChildren((Object)"listener")) != null) {
                for (Element eventListener : eventListeners) {
                    if (!(eventListener instanceof Wrapper)) continue;
                    JpdlSerializer.this.appendToBuffer(buffer, (Wrapper)eventListener, level + 1);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SubprocessTaskWrapperSerializer
    extends ProcessNodeWrapperSerializer {
        SubprocessTaskWrapperSerializer() {
        }

        @Override
        protected List<String> getAttributesToSave() {
            List<String> result = super.getAttributesToSave();
            result.add("sub-process-id");
            result.add("sub-process-key");
            result.add("outcome");
            return result;
        }

        @Override
        protected String getPropertyName(String attributeName) {
            if ("sub-process-id".equals(attributeName)) {
                return "org.jboss.tools.flow.jpdl4.model.subprocess.id";
            }
            if ("sub-process-key".equals(attributeName)) {
                return "org.jboss.tools.flow.jpdl4.model.subprocess.key";
            }
            if ("outcome".equals(attributeName)) {
                return "org.jboss.tools.flow.jpdl4.model.subprocess.outcome";
            }
            return super.getPropertyName(attributeName);
        }

        @Override
        public void appendBody(StringBuffer buffer, Wrapper wrapper, int level) {
            List outputParameters;
            List inputParameters = wrapper.getChildren((Object)"org.jboss.tools.flow.jpdl4.model.subprocess.inputParameters");
            if (inputParameters != null) {
                for (Element inputParameter : inputParameters) {
                    if (!(inputParameter instanceof Wrapper)) continue;
                    JpdlSerializer.this.appendToBuffer(buffer, (Wrapper)inputParameter, level + 1);
                }
            }
            if ((outputParameters = wrapper.getChildren((Object)"org.jboss.tools.flow.jpdl4.model.subprocess.outputParameters")) != null) {
                for (Element outputParameter : outputParameters) {
                    if (!(outputParameter instanceof Wrapper)) continue;
                    JpdlSerializer.this.appendToBuffer(buffer, (Wrapper)outputParameter, level + 1);
                }
            }
            super.appendBody(buffer, wrapper, level);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SwimlaneWrapperSerializer
    extends AbstractWrapperSerializer {
        SwimlaneWrapperSerializer() {
        }

        @Override
        protected List<String> getAttributesToSave() {
            ArrayList<String> result = new ArrayList<String>();
            result.add("name");
            result.add("assignee");
            result.add("candidate-groups");
            result.add("swimlane");
            return result;
        }

        @Override
        protected void appendAttributeToSave(String attributeName, StringBuffer buffer, Wrapper wrapper) {
            Element element = wrapper.getElement();
            if (!(element instanceof Swimlane)) {
                return;
            }
            if ("assignee".equals(attributeName)) {
                this.appendExpression("assignee", buffer, wrapper);
            } else if ("candidate-groups".equals(attributeName)) {
                this.appendExpression("candidate-groups", buffer, wrapper);
            } else if ("swimlane".equals(attributeName)) {
                this.appendExpression("swimlane", buffer, wrapper);
            } else if ("name".equals(attributeName)) {
                this.appendName(buffer, wrapper);
            }
        }

        protected void appendName(StringBuffer buffer, Wrapper wrapper) {
            String value = (String)wrapper.getPropertyValue((Object)"org.jboss.tools.flow.common.model.name");
            if (value == null || "".equals(value)) {
                return;
            }
            buffer.append(" name=\"" + value + "\"");
        }

        protected void appendExpression(String type, StringBuffer buffer, Wrapper wrapper) {
            Object assignmentType = wrapper.getPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.assignment.type");
            if (!(assignmentType instanceof Integer)) {
                return;
            }
            if (type.equals(HumanTask.ASSIGNMENT_TYPES[(Integer)assignmentType])) {
                Object value = wrapper.getPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.assignment.expression");
                if (value == null || "".equals(value)) {
                    return;
                }
                buffer.append(" " + type + "=\"" + value + "\"");
            }
        }

        @Override
        public void appendOpening(StringBuffer buffer, Wrapper wrapper, int level) {
            this.appendLeadingNodes(buffer, wrapper, level);
            buffer.append("<swimlane");
            this.appendAttributes(buffer, wrapper, level);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TerminateEndEventWrapperSerializer
    extends ProcessNodeWrapperSerializer {
        TerminateEndEventWrapperSerializer() {
        }

        @Override
        protected List<String> getAttributesToSave() {
            List<String> result = super.getAttributesToSave();
            result.add("ends");
            result.add("state");
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TimerWrapperSerializer
    extends AbstractWrapperSerializer {
        TimerWrapperSerializer() {
        }

        @Override
        protected List<String> getAttributesToSave() {
            ArrayList<String> result = new ArrayList<String>();
            result.add("duedate");
            result.add("repeat");
            result.add("duedatetime");
            return result;
        }

        @Override
        protected String getPropertyName(String attributeName) {
            if ("duedate".equals(attributeName)) {
                return "org.jboss.tools.flow.jpdl4.model.timer.dueDate";
            }
            if ("repeat".equals(attributeName)) {
                return "org.jboss.tools.flow.jpdl4.model.timer.repeat";
            }
            if ("duedatetime".equals(attributeName)) {
                return "org.jboss.tools.flow.jpdl4.model.timer.dueDateTime";
            }
            return super.getPropertyName(attributeName);
        }
    }

    static interface WrapperSerializer {
        public void appendOpening(StringBuffer var1, Wrapper var2, int var3);
    }
}

