/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.jpdl4.editor;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.jboss.tools.flow.common.registry.ElementRegistry;
import org.jboss.tools.flow.common.wrapper.ConnectionWrapper;
import org.jboss.tools.flow.common.wrapper.DefaultWrapper;
import org.jboss.tools.flow.common.wrapper.FlowWrapper;
import org.jboss.tools.flow.common.wrapper.NodeWrapper;
import org.jboss.tools.flow.common.wrapper.Wrapper;
import org.jboss.tools.flow.jpdl4.Logger;
import org.jboss.tools.flow.jpdl4.model.Argument;
import org.jboss.tools.flow.jpdl4.model.AssignmentPropertySource;
import org.jboss.tools.flow.jpdl4.model.EventListener;
import org.jboss.tools.flow.jpdl4.model.EventListenerContainer;
import org.jboss.tools.flow.jpdl4.model.ExclusiveGateway;
import org.jboss.tools.flow.jpdl4.model.Field;
import org.jboss.tools.flow.jpdl4.model.HumanTask;
import org.jboss.tools.flow.jpdl4.model.InputParameter;
import org.jboss.tools.flow.jpdl4.model.JavaTask;
import org.jboss.tools.flow.jpdl4.model.OutputParameter;
import org.jboss.tools.flow.jpdl4.model.Parameter;
import org.jboss.tools.flow.jpdl4.model.Process;
import org.jboss.tools.flow.jpdl4.model.ScriptTask;
import org.jboss.tools.flow.jpdl4.model.SubprocessTask;
import org.jboss.tools.flow.jpdl4.model.Swimlane;
import org.jboss.tools.flow.jpdl4.model.TerminateEndEvent;
import org.jboss.tools.flow.jpdl4.model.Timer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JpdlDeserializer {
    private static DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public Wrapper deserialize(InputStream is) {
        Wrapper result = null;
        try {
            Document document = documentBuilderFactory.newDocumentBuilder().parse(is);
            result = this.createWrapper(document.getDocumentElement());
        }
        catch (Exception e) {
            Logger.logError("An error occurred while creating the diagram", e);
        }
        return result;
    }

    private Wrapper createWrapper(Element element) {
        PostProcessor postProcessor;
        ChildNodeDeserializer childNodeHandler;
        String elementId = this.getElementId(element.getNodeName());
        if (elementId == null) {
            return null;
        }
        Wrapper result = ElementRegistry.createWrapper((String)elementId);
        if (result == null) {
            return null;
        }
        AttributeDeserializer attributeHandler = this.getAttributeHandler(result);
        if (attributeHandler != null) {
            attributeHandler.deserializeAttributes(result, element);
        }
        if ((childNodeHandler = this.getChildNodeHandler(result)) != null) {
            NodeList nodeList = element.getChildNodes();
            ArrayList<Node> unknownNodeList = new ArrayList<Node>();
            int i = 0;
            while (i < nodeList.getLength()) {
                Wrapper childWrapper = childNodeHandler.deserializeChildNode(result, nodeList.item(i));
                if (childWrapper != null) {
                    childWrapper.getElement().setMetaData("leadingNodes", unknownNodeList);
                    unknownNodeList = new ArrayList();
                } else {
                    unknownNodeList.add(nodeList.item(i));
                }
                ++i;
            }
            result.getElement().setMetaData("trailingNodes", unknownNodeList);
        }
        if ((postProcessor = this.getPostProcessor(result)) != null) {
            postProcessor.postProcess(result);
        }
        return result;
    }

    private PostProcessor getPostProcessor(Wrapper wrapper) {
        if (wrapper instanceof FlowWrapper) {
            return new ProcessPostProcessor();
        }
        return null;
    }

    private AttributeDeserializer getAttributeHandler(Wrapper wrapper) {
        if (wrapper instanceof FlowWrapper) {
            return new ProcessAttributeHandler();
        }
        if (wrapper instanceof NodeWrapper) {
            return this.getNodeAttributeHandler(wrapper);
        }
        if (wrapper instanceof ConnectionWrapper) {
            return new SequenceFlowAttributeHandler();
        }
        if (wrapper instanceof DefaultWrapper) {
            return this.getDefaultAttributeHandler(wrapper);
        }
        return null;
    }

    private AttributeDeserializer getDefaultAttributeHandler(Wrapper wrapper) {
        org.jboss.tools.flow.common.model.Element element = wrapper.getElement();
        if (element instanceof Swimlane) {
            return new SwimlaneAttributeHandler();
        }
        if (element instanceof Timer) {
            return new TimerAttributeHandler();
        }
        if (element instanceof EventListenerContainer) {
            return new EventListenerContainerAttributeHandler();
        }
        if (element instanceof EventListener) {
            return new EventListenerAttributeHandler();
        }
        if (element instanceof Parameter) {
            return new ParameterAttributeHandler();
        }
        if (element instanceof Argument) {
            return new ArgumentAttributeHandler();
        }
        if (element instanceof Field) {
            return new FieldAttributeHandler();
        }
        return null;
    }

    private AttributeDeserializer getNodeAttributeHandler(Wrapper wrapper) {
        org.jboss.tools.flow.common.model.Element element = wrapper.getElement();
        if (element instanceof HumanTask) {
            return new HumanTaskAttributeHandler();
        }
        if (element instanceof SubprocessTask) {
            return new SubprocessTaskAttributeHandler();
        }
        if (element instanceof ExclusiveGateway) {
            return new ExclusiveGatewayAttributeHandler();
        }
        if (element instanceof TerminateEndEvent) {
            return new TerminateEndEventAttributeHandler();
        }
        if (element instanceof JavaTask) {
            return new JavaTaskAttributeHandler();
        }
        if (element instanceof ScriptTask) {
            return new ScriptTaskAttributeHandler();
        }
        return new NodeAttributeHandler();
    }

    private ChildNodeDeserializer getChildNodeHandler(Wrapper wrapper) {
        if (wrapper instanceof FlowWrapper) {
            return new ProcessChildNodeHandler();
        }
        if (wrapper instanceof NodeWrapper) {
            return this.getNodeChildNodeDeserializer(wrapper);
        }
        if (wrapper instanceof DefaultWrapper) {
            return this.getDefaultChildNodeHandler(wrapper);
        }
        if (wrapper instanceof ConnectionWrapper) {
            return new SequenceFlowChildNodeHandler();
        }
        return null;
    }

    private ChildNodeDeserializer getNodeChildNodeDeserializer(Wrapper wrapper) {
        org.jboss.tools.flow.common.model.Element element = wrapper.getElement();
        if (element instanceof ExclusiveGateway) {
            return new ExclusiveGateWayChildNodeHandler();
        }
        if (element instanceof ScriptTask) {
            return new ScriptTaskChildNodeHandler();
        }
        if (element instanceof SubprocessTask) {
            return new SubprocessTaskChildNodeHandler();
        }
        if (element instanceof JavaTask) {
            return new JavaTaskChildNodeHandler();
        }
        return new NodeChildNodeHandler();
    }

    private ChildNodeDeserializer getDefaultChildNodeHandler(Wrapper wrapper) {
        org.jboss.tools.flow.common.model.Element element = wrapper.getElement();
        if (element == null) {
            return null;
        }
        if (element instanceof EventListenerContainer) {
            return new EventListenerContainerChildNodeHandler();
        }
        if (element instanceof Argument) {
            return new ArgumentChildNodeHandler();
        }
        if (element instanceof Field) {
            return new FieldChildNodeHandler();
        }
        return null;
    }

    private String getElementId(String nodeName) {
        if ("process".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.process";
        }
        if ("start".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.startEvent";
        }
        if ("end".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.terminateEndEvent";
        }
        if ("end-error".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.errorEndEvent";
        }
        if ("end-cancel".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.cancelEndEvent";
        }
        if ("state".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.waitTask";
        }
        if ("hql".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.hqlTask";
        }
        if ("sql".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.sqlTask";
        }
        if ("java".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.javaTask";
        }
        if ("script".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.scriptTask";
        }
        if ("esb".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.serviceTask";
        }
        if ("mail".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.mailTask";
        }
        if ("task".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.humanTask";
        }
        if ("custom".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.customTask";
        }
        if ("sub-process".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.subprocessTask";
        }
        if ("decision".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.exclusiveGateway";
        }
        if ("join".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.parallelJoinGateway";
        }
        if ("fork".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.parallelForkGateway";
        }
        if ("transition".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.sequenceFlow";
        }
        if ("swimlane".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.swimlane";
        }
        if ("timer".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.timer";
        }
        if ("on".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.eventListenerContainer";
        }
        if ("event-listener".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.eventListener";
        }
        if ("parameter-in".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.inputParameter";
        }
        if ("parameter-out".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.outputParameter";
        }
        if ("field".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.field";
        }
        if ("arg".equals(nodeName)) {
            return "org.jboss.tools.flow.jpdl4.argument";
        }
        return null;
    }

    private NodeWrapper getNamedNode(String name, FlowWrapper flowWrapper) {
        if (name == null) {
            return null;
        }
        for (NodeWrapper nodeWrapper : flowWrapper.getNodeWrappers()) {
            if (!name.equals(nodeWrapper.getName())) continue;
            return nodeWrapper;
        }
        return null;
    }

    private void addGraphics(ConnectionWrapper wrapper, Element element) {
        String graphics = element.getAttribute("g");
        if (graphics != null && !"".equals(graphics)) {
            String labelInfo;
            int pos = graphics.lastIndexOf(58);
            String bendpointInfo = null;
            if (pos != -1) {
                labelInfo = graphics.substring(pos + 1);
                bendpointInfo = graphics.substring(0, pos);
            } else {
                labelInfo = graphics;
            }
            if (labelInfo != null && !"".equals(labelInfo)) {
                this.addLabelInfo(wrapper, labelInfo);
            }
            if (bendpointInfo != null && !"".equals(bendpointInfo)) {
                this.addBendpointInfo(wrapper, bendpointInfo);
            }
        }
    }

    private void addBendpointInfo(ConnectionWrapper wrapper, String bendpointInfo) {
        StringTokenizer bendpoints = new StringTokenizer(bendpointInfo, ";");
        int index = 0;
        while (bendpoints.hasMoreTokens()) {
            StringTokenizer bendpoint = new StringTokenizer(bendpoints.nextToken(), ",");
            if (bendpoint.countTokens() != 2) {
                Logger.logInfo("Wrong info in attribute 'g' while determining bendpoints.");
                continue;
            }
            int x = this.convertStringToInt(bendpoint.nextToken());
            int y = this.convertStringToInt(bendpoint.nextToken());
            wrapper.addBendpoint(index++, new Point(x, y));
        }
    }

    private void addLabelInfo(ConnectionWrapper wrapper, String labelInfo) {
        StringTokenizer label = new StringTokenizer(labelInfo, ",");
        if (label.countTokens() != 2) {
            Logger.logInfo("Wrong info in attribute 'g' while determining label location.");
        } else {
            int x = this.convertStringToInt(label.nextToken());
            int y = this.convertStringToInt(label.nextToken());
            wrapper.getLabel().setLocation(new Point(x, y));
        }
    }

    private void addGraphics(NodeWrapper wrapper, Element element) {
        String graphics = element.getAttribute("g");
        Rectangle constraint = new Rectangle(0, 0, 80, 40);
        if (graphics != null) {
            StringTokenizer tokenizer = new StringTokenizer(graphics, ",");
            if (tokenizer.countTokens() != 4) {
                Logger.logInfo("Wrong info in attribute 'g' for element '" + element.getNodeName() + "'" + " with name '" + element.getAttribute("name") + "'. Using defaults.");
            } else {
                constraint.x = this.convertStringToInt(tokenizer.nextToken());
                constraint.y = this.convertStringToInt(tokenizer.nextToken());
                constraint.width = this.convertStringToInt(tokenizer.nextToken());
                constraint.height = this.convertStringToInt(tokenizer.nextToken());
            }
        }
        wrapper.setConstraint(constraint);
    }

    private int convertStringToInt(String str) {
        int result = 0;
        try {
            result = new Integer(str);
        }
        catch (NumberFormatException e) {
            Logger.logError("Error while converting " + str + " to an integer.", e);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ArgumentAttributeHandler
    extends DefaultAttributeDeserializer {
        ArgumentAttributeHandler() {
        }

        @Override
        protected List<String> getAttributesToRead() {
            List<String> result = super.getAttributesToRead();
            return result;
        }
    }

    class ArgumentChildNodeHandler
    extends NodeChildNodeHandler {
        ArgumentChildNodeHandler() {
        }

        public Wrapper deserializeChildNode(Wrapper parent, Node node) {
            Wrapper result = null;
            if (node instanceof Element && "string".equals(node.getNodeName())) {
                String value = ((Element)node).getAttribute("value");
                if (value != null && !"".equals(value)) {
                    parent.setPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.argument.value", (Object)value);
                }
            } else {
                result = super.deserializeChildNode(parent, node);
            }
            return result;
        }
    }

    class AssignmentAttributeHandler
    implements AttributeDeserializer {
        AssignmentAttributeHandler() {
        }

        public void deserializeAttributes(Wrapper wrapper, Element element) {
            String assignee = element.getAttribute("assignee");
            if (!"".equals(assignee)) {
                wrapper.setPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.assignment.type", (Object)AssignmentPropertySource.getAssignmentTypesIndex("assignee"));
                wrapper.setPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.assignment.expression", (Object)assignee);
                return;
            }
            String candidateGroups = element.getAttribute("candidate-groups");
            if (!"".equals(candidateGroups)) {
                wrapper.setPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.assignment.type", (Object)AssignmentPropertySource.getAssignmentTypesIndex("candidate-groups"));
                wrapper.setPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.assignment.expression", (Object)candidateGroups);
                return;
            }
            String swimlane = element.getAttribute("swimlane");
            if (!"".equals(swimlane)) {
                wrapper.setPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.assignment.type", (Object)AssignmentPropertySource.getAssignmentTypesIndex("swimlane"));
                wrapper.setPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.assignment.expression", (Object)swimlane);
                return;
            }
        }
    }

    static interface AttributeDeserializer {
        public void deserializeAttributes(Wrapper var1, Element var2);
    }

    static interface ChildNodeDeserializer {
        public Wrapper deserializeChildNode(Wrapper var1, Node var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DefaultAttributeDeserializer
    implements AttributeDeserializer {
        DefaultAttributeDeserializer() {
        }

        protected List<String> getAttributesToRead() {
            return new ArrayList<String>();
        }

        protected String getXmlName(String attributeName) {
            return null;
        }

        @Override
        public void deserializeAttributes(Wrapper wrapper, Element element) {
            wrapper.getElement().setMetaData("attributes", (Object)element.getAttributes());
            List<String> attributeNames = this.getAttributesToRead();
            for (String attributeName : attributeNames) {
                String attribute;
                String xmlName = this.getXmlName(attributeName);
                if (xmlName == null || "".equals(attribute = element.getAttribute(xmlName)) || attribute == null) continue;
                wrapper.setPropertyValue((Object)attributeName, (Object)attribute);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EventListenerAttributeHandler
    extends DefaultAttributeDeserializer {
        EventListenerAttributeHandler() {
        }

        @Override
        protected List<String> getAttributesToRead() {
            ArrayList<String> result = new ArrayList<String>();
            result.add("org.jboss.tools.flow.jpdl4.model.eventListener.className");
            return result;
        }

        @Override
        protected String getXmlName(String attributeName) {
            if ("org.jboss.tools.flow.jpdl4.model.eventListener.className".equals(attributeName)) {
                return "class";
            }
            return super.getXmlName(attributeName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EventListenerContainerAttributeHandler
    extends DefaultAttributeDeserializer {
        EventListenerContainerAttributeHandler() {
        }

        @Override
        protected List<String> getAttributesToRead() {
            ArrayList<String> result = new ArrayList<String>();
            result.add("org.jboss.tools.flow.jpdl4.model.eventListenerContainer.eventType");
            return result;
        }

        @Override
        protected String getXmlName(String attributeName) {
            if ("org.jboss.tools.flow.jpdl4.model.eventListenerContainer.eventType".equals(attributeName)) {
                return "event";
            }
            return super.getXmlName(attributeName);
        }
    }

    class EventListenerContainerChildNodeHandler
    implements ChildNodeDeserializer {
        EventListenerContainerChildNodeHandler() {
        }

        public Wrapper deserializeChildNode(Wrapper parent, Node node) {
            Wrapper result = null;
            if (!(parent.getElement() instanceof EventListenerContainer)) {
                return result;
            }
            if (node instanceof Element && (result = JpdlDeserializer.this.createWrapper((Element)node)) != null) {
                if (result.getElement() instanceof EventListener) {
                    parent.addChild((Object)"org.jboss.tools.flow.jpdl4.model.eventListenerContainer.listeners", (org.jboss.tools.flow.common.model.Element)result);
                } else if (result.getElement() instanceof Timer) {
                    parent.setPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.eventListenerContainer.duedate", result.getPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.timer.dueDate"));
                    parent.setPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.eventListenerContainer.repeat", result.getPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.timer.repeat"));
                }
            }
            return result;
        }
    }

    class ExclusiveGateWayChildNodeHandler
    extends NodeChildNodeHandler {
        ExclusiveGateWayChildNodeHandler() {
        }

        public Wrapper deserializeChildNode(Wrapper parent, Node node) {
            Wrapper result = null;
            ExclusiveGateway exclusiveGateway = (ExclusiveGateway)parent.getElement();
            if (node instanceof Element && "handler".equals(node.getNodeName())) {
                String className = ((Element)node).getAttribute("class");
                exclusiveGateway.setHandler("".equals(className) ? null : className);
            } else {
                result = super.deserializeChildNode(parent, node);
            }
            return result;
        }
    }

    class ExclusiveGatewayAttributeHandler
    extends NodeAttributeHandler {
        ExclusiveGatewayAttributeHandler() {
        }

        public void deserializeAttributes(Wrapper wrapper, Element element) {
            super.deserializeAttributes(wrapper, element);
            if (!(wrapper.getElement() instanceof ExclusiveGateway)) {
                return;
            }
            ExclusiveGateway exclusiveGateWay = (ExclusiveGateway)wrapper.getElement();
            exclusiveGateWay.setExpr(element.getAttribute("expr"));
            exclusiveGateWay.setLang(element.getAttribute("lang"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FieldAttributeHandler
    extends DefaultAttributeDeserializer {
        FieldAttributeHandler() {
        }

        @Override
        protected List<String> getAttributesToRead() {
            List<String> result = super.getAttributesToRead();
            result.add("org.jboss.tools.flow.jpdl4.model.field.name");
            return result;
        }

        @Override
        protected String getXmlName(String attributeName) {
            if ("org.jboss.tools.flow.jpdl4.model.field.name".equals(attributeName)) {
                return "name";
            }
            return super.getXmlName(attributeName);
        }
    }

    class FieldChildNodeHandler
    extends NodeChildNodeHandler {
        FieldChildNodeHandler() {
        }

        public Wrapper deserializeChildNode(Wrapper parent, Node node) {
            Wrapper result = null;
            if (node instanceof Element && "string".equals(node.getNodeName())) {
                String value = ((Element)node).getAttribute("value");
                if (value != null && !"".equals(value)) {
                    parent.setPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.field.value", (Object)value);
                }
            } else {
                result = super.deserializeChildNode(parent, node);
            }
            return result;
        }
    }

    class HumanTaskAttributeHandler
    extends NodeAttributeHandler {
        AssignmentAttributeHandler assignmentAttributeHandler;

        HumanTaskAttributeHandler() {
            this.assignmentAttributeHandler = new AssignmentAttributeHandler();
        }

        public void deserializeAttributes(Wrapper wrapper, Element element) {
            super.deserializeAttributes(wrapper, element);
            this.assignmentAttributeHandler.deserializeAttributes(wrapper, element);
        }
    }

    class JavaTaskAttributeHandler
    extends NodeAttributeHandler {
        JavaTaskAttributeHandler() {
        }

        public void deserializeAttributes(Wrapper wrapper, Element element) {
            super.deserializeAttributes(wrapper, element);
            wrapper.setPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.javaTask.class", (Object)element.getAttribute("class"));
            wrapper.setPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.javaTask.method", (Object)element.getAttribute("method"));
            wrapper.setPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.javaTask.var", (Object)element.getAttribute("var"));
        }
    }

    class JavaTaskChildNodeHandler
    extends NodeChildNodeHandler {
        JavaTaskChildNodeHandler() {
        }

        public Wrapper deserializeChildNode(Wrapper parent, Node node) {
            Wrapper result = super.deserializeChildNode(parent, node);
            if (result == null) {
                return result;
            }
            if (result.getElement() instanceof Argument) {
                parent.addChild((Object)"org.jboss.tools.flow.jpdl4.model.javaTask.args", (org.jboss.tools.flow.common.model.Element)result);
            } else if (result.getElement() instanceof Field) {
                parent.addChild((Object)"org.jboss.tools.flow.jpdl4.model.javaTask.fields", (org.jboss.tools.flow.common.model.Element)result);
            }
            return result;
        }
    }

    class NodeAttributeHandler
    extends DefaultAttributeDeserializer {
        NodeAttributeHandler() {
        }

        public void deserializeAttributes(Wrapper wrapper, Element element) {
            super.deserializeAttributes(wrapper, element);
            if (!(wrapper instanceof NodeWrapper)) {
                return;
            }
            NodeWrapper nodeWrapper = (NodeWrapper)wrapper;
            JpdlDeserializer.this.addGraphics(nodeWrapper, element);
            nodeWrapper.setName(element.getAttribute("name"));
        }
    }

    class NodeChildNodeHandler
    implements ChildNodeDeserializer {
        NodeChildNodeHandler() {
        }

        public Wrapper deserializeChildNode(Wrapper parent, Node node) {
            Wrapper result = null;
            if (!(parent instanceof NodeWrapper)) {
                return result;
            }
            NodeWrapper nodeWrapper = (NodeWrapper)parent;
            ArrayList<ConnectionWrapper> flows = (ArrayList<ConnectionWrapper>)nodeWrapper.getElement().getMetaData("flows");
            if (flows == null) {
                flows = new ArrayList<ConnectionWrapper>();
                nodeWrapper.getElement().setMetaData("flows", flows);
            }
            if (node instanceof Element && (result = JpdlDeserializer.this.createWrapper((Element)node)) != null) {
                if (result instanceof ConnectionWrapper) {
                    flows.add((ConnectionWrapper)result);
                } else if (result.getElement() instanceof EventListenerContainer) {
                    parent.addChild((Object)"eventListener", (org.jboss.tools.flow.common.model.Element)result);
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ParameterAttributeHandler
    extends DefaultAttributeDeserializer {
        ParameterAttributeHandler() {
        }

        @Override
        protected List<String> getAttributesToRead() {
            List<String> result = super.getAttributesToRead();
            result.add("org.jboss.tools.flow.jpdl4.model.parameter.var");
            result.add("org.jboss.tools.flow.jpdl4.model.parameter.subvar");
            result.add("org.jboss.tools.flow.jpdl4.model.parameter.expr");
            result.add("org.jboss.tools.flow.jpdl4.model.parameter.lang");
            return result;
        }

        @Override
        protected String getXmlName(String attributeName) {
            if ("org.jboss.tools.flow.jpdl4.model.parameter.var".equals(attributeName)) {
                return "var";
            }
            if ("org.jboss.tools.flow.jpdl4.model.parameter.subvar".equals(attributeName)) {
                return "subvar";
            }
            if ("org.jboss.tools.flow.jpdl4.model.parameter.expr".equals(attributeName)) {
                return "expr";
            }
            if ("org.jboss.tools.flow.jpdl4.model.parameter.lang".equals(attributeName)) {
                return "lang";
            }
            return super.getXmlName(attributeName);
        }
    }

    static interface PostProcessor {
        public void postProcess(Wrapper var1);
    }

    class ProcessAttributeHandler
    extends DefaultAttributeDeserializer {
        ProcessAttributeHandler() {
        }

        public void deserializeAttributes(Wrapper wrapper, Element element) {
            super.deserializeAttributes(wrapper, element);
            if (!(wrapper.getElement() instanceof Process)) {
                return;
            }
            Process process = (Process)wrapper.getElement();
            process.setName(element.getAttribute("name"));
            process.setKey(element.getAttribute("key"));
            process.setVersion(element.getAttribute("version"));
            process.setDescription(element.getAttribute("description"));
        }
    }

    class ProcessChildNodeHandler
    implements ChildNodeDeserializer {
        ProcessChildNodeHandler() {
        }

        public Wrapper deserializeChildNode(Wrapper parent, Node node) {
            Wrapper result = null;
            if (!(parent instanceof FlowWrapper)) {
                return result;
            }
            FlowWrapper flowWrapper = (FlowWrapper)parent;
            if (node instanceof Element) {
                result = JpdlDeserializer.this.createWrapper((Element)node);
                if (result == null) {
                    return null;
                }
                if (result instanceof NodeWrapper) {
                    flowWrapper.addElement((NodeWrapper)result);
                } else if (result.getElement() instanceof Swimlane) {
                    flowWrapper.addChild((Object)"swimlane", (org.jboss.tools.flow.common.model.Element)result);
                } else if (result.getElement() instanceof Timer) {
                    flowWrapper.addChild((Object)"timer", (org.jboss.tools.flow.common.model.Element)result);
                } else if (result.getElement() instanceof EventListenerContainer) {
                    flowWrapper.addChild((Object)"eventListener", (org.jboss.tools.flow.common.model.Element)result);
                }
            }
            return result;
        }
    }

    class ProcessPostProcessor
    implements PostProcessor {
        ProcessPostProcessor() {
        }

        public void postProcess(Wrapper wrapper) {
            if (!(wrapper instanceof FlowWrapper)) {
                return;
            }
            FlowWrapper flowWrapper = (FlowWrapper)wrapper;
            for (NodeWrapper source : flowWrapper.getNodeWrappers()) {
                ArrayList flows = (ArrayList)source.getElement().getMetaData("flows");
                if (flows == null) continue;
                for (ConnectionWrapper connectionWrapper : flows) {
                    String to = (String)connectionWrapper.getElement().getMetaData("to");
                    if (to == null) {
                        Logger.logInfo("Ignoring sequenceflow without target");
                        continue;
                    }
                    NodeWrapper target = JpdlDeserializer.this.getNamedNode(to, flowWrapper);
                    if (target == null) {
                        Logger.logInfo("Ignoring unknown target " + to + " while resolving sequenceflow target.");
                        continue;
                    }
                    connectionWrapper.connect(source, target);
                }
            }
        }
    }

    class ScriptTaskAttributeHandler
    extends NodeAttributeHandler {
        ScriptTaskAttributeHandler() {
        }

        public void deserializeAttributes(Wrapper wrapper, Element element) {
            super.deserializeAttributes(wrapper, element);
            wrapper.setPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.scriptTask.expr", (Object)element.getAttribute("expr"));
            wrapper.setPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.scriptTask.lang", (Object)element.getAttribute("lang"));
            wrapper.setPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.javaTask.var", (Object)element.getAttribute("var"));
        }
    }

    class ScriptTaskChildNodeHandler
    extends NodeChildNodeHandler {
        ScriptTaskChildNodeHandler() {
        }

        public Wrapper deserializeChildNode(Wrapper parent, Node node) {
            Wrapper result = null;
            if (node instanceof Element && "text".equals(node.getNodeName())) {
                String text = ((Element)node).getTextContent();
                if (text != null && !"".equals(text)) {
                    parent.setPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.javaTask.text", (Object)text);
                }
            } else {
                result = super.deserializeChildNode(parent, node);
            }
            return result;
        }
    }

    class SequenceFlowAttributeHandler
    extends DefaultAttributeDeserializer {
        SequenceFlowAttributeHandler() {
        }

        public void deserializeAttributes(Wrapper wrapper, Element element) {
            super.deserializeAttributes(wrapper, element);
            if (!(wrapper instanceof ConnectionWrapper)) {
                return;
            }
            ConnectionWrapper connectionWrapper = (ConnectionWrapper)wrapper;
            JpdlDeserializer.this.addGraphics(connectionWrapper, element);
            connectionWrapper.getElement().setMetaData("to", (Object)element.getAttribute("to"));
            connectionWrapper.setPropertyValue((Object)"org.jboss.tools.flow.common.model.name", (Object)element.getAttribute("name"));
        }
    }

    class SequenceFlowChildNodeHandler
    implements ChildNodeDeserializer {
        SequenceFlowChildNodeHandler() {
        }

        public Wrapper deserializeChildNode(Wrapper parent, Node node) {
            Wrapper result = null;
            if (!(parent instanceof ConnectionWrapper)) {
                return result;
            }
            ConnectionWrapper connectionWrapper = (ConnectionWrapper)parent;
            if (node instanceof Element) {
                if ("timer".equals(node.getNodeName())) {
                    String duedate = ((Element)node).getAttribute("duedate");
                    if (duedate != null && !"".equals(duedate)) {
                        parent.setPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.sequenceFlow.timer", (Object)duedate);
                    }
                } else if ("outcome-value".equals(node.getNodeName())) {
                    String value;
                    NodeList nodeList = ((Element)node).getElementsByTagName("string");
                    if (nodeList.getLength() == 1 && (value = ((Element)nodeList.item(0)).getAttribute("value")) != null && !"".equals("value")) {
                        parent.setPropertyValue((Object)"org.jboss.tools.flow.jpdl4.model.sequenceFlow.outcome", (Object)value);
                    }
                } else {
                    result = JpdlDeserializer.this.createWrapper((Element)node);
                }
                if (result == null) {
                    return null;
                }
                if (result instanceof Wrapper && result.getElement() instanceof EventListener) {
                    connectionWrapper.addChild((Object)"listener", (org.jboss.tools.flow.common.model.Element)result);
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SubprocessTaskAttributeHandler
    extends NodeAttributeHandler {
        SubprocessTaskAttributeHandler() {
        }

        @Override
        protected List<String> getAttributesToRead() {
            List<String> result = super.getAttributesToRead();
            result.add("org.jboss.tools.flow.jpdl4.model.subprocess.id");
            result.add("org.jboss.tools.flow.jpdl4.model.subprocess.key");
            result.add("org.jboss.tools.flow.jpdl4.model.subprocess.outcome");
            return result;
        }

        @Override
        protected String getXmlName(String attributeName) {
            if ("org.jboss.tools.flow.jpdl4.model.subprocess.id".equals(attributeName)) {
                return "sub-process-id";
            }
            if ("org.jboss.tools.flow.jpdl4.model.subprocess.key".equals(attributeName)) {
                return "sub-process-key";
            }
            if ("org.jboss.tools.flow.jpdl4.model.subprocess.outcome".equals(attributeName)) {
                return "outcome";
            }
            return super.getXmlName(attributeName);
        }
    }

    class SubprocessTaskChildNodeHandler
    extends NodeChildNodeHandler {
        SubprocessTaskChildNodeHandler() {
        }

        public Wrapper deserializeChildNode(Wrapper parent, Node node) {
            Wrapper result = super.deserializeChildNode(parent, node);
            if (result == null) {
                return result;
            }
            if (result.getElement() instanceof InputParameter) {
                parent.addChild((Object)"org.jboss.tools.flow.jpdl4.model.subprocess.inputParameters", (org.jboss.tools.flow.common.model.Element)result);
            } else if (result.getElement() instanceof OutputParameter) {
                parent.addChild((Object)"org.jboss.tools.flow.jpdl4.model.subprocess.outputParameters", (org.jboss.tools.flow.common.model.Element)result);
            }
            return result;
        }
    }

    class SwimlaneAttributeHandler
    extends DefaultAttributeDeserializer {
        AssignmentAttributeHandler assignmentAttributeHandler;

        SwimlaneAttributeHandler() {
            this.assignmentAttributeHandler = new AssignmentAttributeHandler();
        }

        public void deserializeAttributes(Wrapper wrapper, Element element) {
            super.deserializeAttributes(wrapper, element);
            String name = element.getAttribute("name");
            if (!"".equals(name) && name != null) {
                wrapper.setPropertyValue((Object)"org.jboss.tools.flow.common.model.name", (Object)name);
            }
            this.assignmentAttributeHandler.deserializeAttributes(wrapper, element);
        }
    }

    class TerminateEndEventAttributeHandler
    extends NodeAttributeHandler {
        TerminateEndEventAttributeHandler() {
        }

        public void deserializeAttributes(Wrapper wrapper, Element element) {
            super.deserializeAttributes(wrapper, element);
            if (!(wrapper.getElement() instanceof TerminateEndEvent)) {
                return;
            }
            TerminateEndEvent terminateEndEvent = (TerminateEndEvent)wrapper.getElement();
            terminateEndEvent.setEnds(element.getAttribute("ends"));
            terminateEndEvent.setState(element.getAttribute("state"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TimerAttributeHandler
    extends DefaultAttributeDeserializer {
        TimerAttributeHandler() {
        }

        @Override
        protected List<String> getAttributesToRead() {
            List<String> result = super.getAttributesToRead();
            result.add("org.jboss.tools.flow.jpdl4.model.timer.dueDate");
            result.add("org.jboss.tools.flow.jpdl4.model.timer.repeat");
            result.add("org.jboss.tools.flow.jpdl4.model.timer.dueDateTime");
            return result;
        }

        @Override
        protected String getXmlName(String attributeName) {
            if ("org.jboss.tools.flow.jpdl4.model.timer.dueDate".equals(attributeName)) {
                return "duedate";
            }
            if ("org.jboss.tools.flow.jpdl4.model.timer.repeat".equals(attributeName)) {
                return "repeat";
            }
            if ("org.jboss.tools.flow.jpdl4.model.timer.dueDateTime".equals(attributeName)) {
                return "duedatetime";
            }
            return super.getXmlName(attributeName);
        }
    }
}

