/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jbpm.preferences;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.jboss.tools.jbpm.preferences.JbpmInstallation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesManager {
    private static Map<Plugin, PreferencesManager> managerMap = new HashMap<Plugin, PreferencesManager>();
    private Map<String, JbpmInstallation> jbpmInstallations = null;
    private File installationsFile = null;
    private Plugin plugin;

    public static PreferencesManager getPreferencesManager(Plugin key) {
        PreferencesManager preferencesManager = managerMap.get(key);
        if (preferencesManager == null) {
            preferencesManager = new PreferencesManager(key);
            managerMap.put(key, preferencesManager);
        }
        return preferencesManager;
    }

    private PreferencesManager(Plugin plugin) {
        this.plugin = plugin;
        this.initializeInstallations();
    }

    private File getInstallationFile() {
        if (this.installationsFile == null) {
            this.initializeInstallations();
        }
        return this.installationsFile;
    }

    private Map<String, JbpmInstallation> getJbpmInstallations() {
        if (this.jbpmInstallations == null) {
            this.jbpmInstallations = new HashMap<String, JbpmInstallation>();
        }
        return this.jbpmInstallations;
    }

    private Preferences getPreferences() {
        return this.plugin.getPluginPreferences();
    }

    private void initializeInstallations() {
        this.installationsFile = this.plugin.getStateLocation().append("jbpm-installations.xml").toFile();
        if (!this.installationsFile.exists()) {
            this.createInstallationsFile();
        } else {
            this.loadInstallations();
        }
    }

    private void createInstallationsFile() {
        try {
            this.installationsFile.createNewFile();
            this.saveInstallations();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadInstallations() {
        FileReader reader = null;
        try {
            try {
                reader = new FileReader(this.getInstallationFile());
                XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                IMemento[] children = memento.getChildren("installation");
                int i = 0;
                while (i < children.length) {
                    JbpmInstallation installation = new JbpmInstallation();
                    installation.name = children[i].getString("name");
                    installation.location = children[i].getString("location");
                    installation.version = children[i].getString("version");
                    this.getJbpmInstallations().put(installation.name, installation);
                    ++i;
                }
            }
            catch (WorkbenchException e) {
                e.printStackTrace();
                try {
                    if (reader != null) {
                        ((Reader)reader).close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    if (reader != null) {
                        ((Reader)reader).close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    ((Reader)reader).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveInstallations() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"installations");
        for (String name : this.getJbpmInstallations().keySet()) {
            JbpmInstallation installation = this.getJbpmInstallations().get(name);
            IMemento child = memento.createChild("installation");
            child.putString("name", installation.name);
            child.putString("location", installation.location);
            child.putString("version", installation.version);
        }
        FileWriter writer = null;
        try {
            try {
                writer = new FileWriter(this.getInstallationFile());
                memento.save((Writer)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Map<String, JbpmInstallation> getJbpmInstallationMap() {
        return this.getJbpmInstallations();
    }

    public JbpmInstallation getJbpmInstallation(String name) {
        return this.getJbpmInstallations().get(name);
    }

    public String getPreferredJbpmName() {
        return this.getPreferences().getString("jbpm-name");
    }

    public void setPreferredJbpmName(String name) {
        this.getPreferences().setDefault("jbpm-name", name);
    }

    public void addJbpmInstallation(String name, String location, String version) {
        JbpmInstallation installation = new JbpmInstallation();
        installation.name = name;
        installation.location = location;
        installation.version = version;
        this.getJbpmInstallationMap().put(name, installation);
    }

    public void initializeDefaultJbpmInstallation(String name, String location, String version) {
        this.setPreferredJbpmName(name);
        this.addJbpmInstallation(name, location, version);
        this.saveInstallations();
    }
}

