/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jbpm.preferences;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jboss.tools.jbpm.preferences.AddJbpmInstallationDialog;
import org.jboss.tools.jbpm.preferences.JbpmInstallation;
import org.jboss.tools.jbpm.preferences.JbpmInstallationLabelProvider;
import org.jboss.tools.jbpm.preferences.JbpmInstallationTableContentProvider;
import org.jboss.tools.jbpm.preferences.PreferencesManager;
import org.jboss.tools.jbpm.util.AutoResizeTableLayout;

public abstract class JbpmLocationsPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer tableViewer;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private AbstractUIPlugin plugin;

    public JbpmLocationsPage(AbstractUIPlugin plugin) {
        this.plugin = plugin;
        this.setPreferenceStore(plugin.getPreferenceStore());
    }

    protected abstract AddJbpmInstallationDialog createAddJbpmInstallationDialog(Shell var1);

    protected Control createContents(Composite parent) {
        Composite clientArea = this.createClientArea(parent);
        this.createLabels(clientArea);
        this.createJbpmHomeListTable(clientArea);
        this.createButtons(clientArea);
        return null;
    }

    private void createButtons(Composite parent) {
        GridData gridData = new GridData(1, 1, false, false);
        gridData.widthHint = 80;
        this.addButton = new Button(parent, 8);
        this.addButton.setText("Add...");
        this.addButton.setLayoutData((Object)gridData);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JbpmLocationsPage.this.addNewLocation();
            }
        });
        this.editButton = new Button(parent, 8);
        this.editButton.setText("Edit...");
        this.editButton.setLayoutData((Object)gridData);
        this.editButton.setEnabled(false);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JbpmLocationsPage.this.editLocation();
            }
        });
        this.removeButton = new Button(parent, 8);
        this.removeButton.setText("Remove");
        this.removeButton.setLayoutData((Object)gridData);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JbpmLocationsPage.this.removeLocation();
            }
        });
    }

    private void removeLocation() {
        TableItem item = this.tableViewer.getTable().getSelection()[0];
        String name = item.getText(0);
        PreferencesManager inputManager = (PreferencesManager)this.tableViewer.getInput();
        JbpmInstallation installation = inputManager.getJbpmInstallation(name);
        inputManager.getJbpmInstallationMap().remove(name);
        this.tableViewer.remove((Object)installation);
        this.updateButtons();
        this.updateStatus();
    }

    private void editLocation() {
        TableItem item = this.tableViewer.getTable().getSelection()[0];
        String name = item.getText(0);
        PreferencesManager inputManager = (PreferencesManager)this.tableViewer.getInput();
        JbpmInstallation jbpmInstallation = inputManager.getJbpmInstallation(name);
        AddJbpmInstallationDialog dialog = this.createAddJbpmInstallationDialog(this.getShell());
        dialog.initialize("Edit Location", jbpmInstallation.name, jbpmInstallation.location);
        if (dialog.open() == 0) {
            jbpmInstallation.name = dialog.getName();
            jbpmInstallation.version = dialog.getVersion();
            jbpmInstallation.location = dialog.getLocation();
            this.tableViewer.update((Object)jbpmInstallation, null);
            if (name != dialog.getName()) {
                inputManager.getJbpmInstallationMap().remove(name);
                inputManager.getJbpmInstallationMap().put(dialog.getName(), jbpmInstallation);
            }
        }
        this.updateButtons();
    }

    private void addNewLocation() {
        AddJbpmInstallationDialog dialog = this.createAddJbpmInstallationDialog(this.getShell());
        dialog.initialize("Add Location", "", "");
        if (dialog.open() == 0) {
            PreferencesManager inputManager = (PreferencesManager)this.tableViewer.getInput();
            JbpmInstallation jbpmInstallation = this.getJbpmInstallation(dialog);
            inputManager.getJbpmInstallationMap().put(jbpmInstallation.name, jbpmInstallation);
            this.tableViewer.add((Object)jbpmInstallation);
        }
        this.updateButtons();
    }

    private JbpmInstallation getJbpmInstallation(AddJbpmInstallationDialog dialog) {
        JbpmInstallation jbpmInstallation = new JbpmInstallation();
        jbpmInstallation.name = dialog.getName();
        jbpmInstallation.location = dialog.getLocation();
        jbpmInstallation.version = dialog.getVersion();
        return jbpmInstallation;
    }

    private Composite createClientArea(Composite parent) {
        Composite clientArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        clientArea.setLayoutData((Object)gridData);
        return clientArea;
    }

    public void init(IWorkbench workbench) {
    }

    private void createJbpmHomeListTable(Composite parent) {
        this.tableViewer = new TableViewer(parent, 67618);
        this.tableViewer.setContentProvider((IContentProvider)new JbpmInstallationTableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new JbpmInstallationLabelProvider());
        GridData gridData = new GridData(768);
        gridData.verticalSpan = 3;
        gridData.heightHint = 200;
        this.tableViewer.getControl().setLayoutData((Object)gridData);
        this.initializeTable(this.tableViewer);
        this.createTableColumns(this.tableViewer);
        this.initializeInput(this.tableViewer);
    }

    private void initializeInput(TableViewer viewer) {
        viewer.setInput((Object)PreferencesManager.getPreferencesManager((Plugin)this.plugin));
        this.checkItemToCheck(viewer);
    }

    private void checkItemToCheck(TableViewer viewer) {
        TableItem tableItem;
        String name = this.plugin.getPreferenceStore().getString("jbpm-name");
        if (name != null && (tableItem = this.getItemToCheck(viewer, name)) != null) {
            tableItem.setChecked(true);
        }
    }

    private TableItem getItemToCheck(TableViewer viewer, String name) {
        TableItem[] items = viewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            if (name.equals(items[i].getText(0))) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    private void createTableColumns(TableViewer viewer) {
        Table table = viewer.getTable();
        TableColumn nameColumn = new TableColumn(table, 16384);
        nameColumn.setText("Name");
        ColumnWeightData nameColumnData = new ColumnWeightData(30);
        AutoResizeTableLayout layout = (AutoResizeTableLayout)table.getLayout();
        layout.addColumnData((ColumnLayoutData)nameColumnData);
        TableColumn versionColumn = new TableColumn(table, 16384);
        versionColumn.setText("Version");
        ColumnWeightData versionColumnData = new ColumnWeightData(30);
        layout.addColumnData((ColumnLayoutData)versionColumnData);
        TableColumn locationColumn = new TableColumn(table, 16384);
        locationColumn.setText("Location");
        ColumnWeightData locationColumnData = new ColumnWeightData(40);
        layout.addColumnData((ColumnLayoutData)locationColumnData);
    }

    private void initializeTable(TableViewer viewer) {
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayout((Layout)new AutoResizeTableLayout(table));
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JbpmLocationsPage.this.updateSelection(e);
            }
        });
    }

    private void updateSelection(SelectionEvent e) {
        if (e.detail == 32) {
            this.updateChecks(e);
        } else {
            this.updateButtons();
        }
        this.updateStatus();
    }

    private void updateChecks(SelectionEvent e) {
        Table table = this.tableViewer.getTable();
        TableItem[] items = table.getItems();
        int i = 0;
        while (i < items.length) {
            if (e.item != items[i]) {
                items[i].setChecked(false);
            }
            ++i;
        }
    }

    private void updateStatus() {
        TableItem item = this.getCheckedItem();
        if (item != null) {
            this.setErrorMessage(null);
            this.setValid(true);
        } else {
            this.setErrorMessage("Select a default jBPM installation.");
            this.setValid(false);
        }
    }

    private TableItem getCheckedItem() {
        TableItem[] items = this.tableViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    private void updateButtons() {
        Table table = this.tableViewer.getTable();
        TableItem[] selection = table.getSelection();
        this.editButton.setEnabled(selection.length == 1);
        this.removeButton.setEnabled(selection.length == 1 && table.getItemCount() > 1);
    }

    private void createLabels(Composite parent) {
        GridData infoLabelGridData = new GridData(768);
        infoLabelGridData.horizontalSpan = 2;
        Label infoLabel = new Label(parent, 0);
        infoLabel.setText("Add, remove or edit JBoss jBPM installation locations.\nThe checked location will be used by the jBPM creation wizards.");
        infoLabel.setLayoutData((Object)infoLabelGridData);
        GridData tableLabelGridData = new GridData(1, 0x1000008, false, false);
        tableLabelGridData.horizontalSpan = 2;
        Label tableLabel = new Label(parent, 0);
        tableLabel.setText("jBPM Installation Locations:");
        tableLabel.setLayoutData((Object)tableLabelGridData);
    }

    public boolean performOk() {
        String name = "";
        PreferencesManager inputManager = (PreferencesManager)this.tableViewer.getInput();
        inputManager.saveInstallations();
        TableItem item = this.getCheckedItem(this.tableViewer);
        if (item != null) {
            name = item.getText(0);
        }
        this.plugin.getPluginPreferences().setValue("jbpm-name", name);
        return true;
    }

    private TableItem getCheckedItem(TableViewer viewer) {
        TableItem[] items = viewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    public void performDefaults() {
        this.plugin.getPluginPreferences().setToDefault("jbpm-name");
        PreferencesManager inputManager = (PreferencesManager)this.tableViewer.getInput();
        inputManager.getJbpmInstallationMap().clear();
        this.tableViewer.setInput((Object)inputManager);
        this.checkItemToCheck(this.tableViewer);
        this.setMessage("");
        this.updateButtons();
        this.setValid(true);
    }
}

