/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jbpm.java;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.jbpm.Logger;

public class JavaUtil {
    private static IEditorPart getActiveEditor() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
    }

    private static IFile getCurrentFile() {
        return ((IFileEditorInput)JavaUtil.getActiveEditor().getEditorInput()).getFile();
    }

    private static IType getClassFor(String className) throws JavaModelException {
        if (className == null || JavaUtil.getCurrentProject() == null) {
            return null;
        }
        return JavaUtil.getCurrentProject().findType(className);
    }

    private static IMethod getMethodFor(String className, String methodName) throws JavaModelException {
        IType type = JavaUtil.getClassFor(className);
        if (type != null) {
            IMethod[] methods;
            IMethod[] iMethodArray = methods = type.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (method.getElementName().equals(methodName)) {
                    return method;
                }
                ++n2;
            }
        }
        return null;
    }

    public static IJavaProject getCurrentProject() {
        IJavaProject result = null;
        IProject project = JavaUtil.getCurrentFile().getProject();
        try {
            result = project.hasNature("org.eclipse.jdt.core.javanature") ? JavaCore.create((IProject)project) : null;
        }
        catch (CoreException e) {
            Logger.logError("Problem while getting current project.", e);
        }
        return result;
    }

    public static String[] getFields(String className) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            IType type = JavaUtil.getClassFor(className);
            if (type != null) {
                IField[] fields;
                IField[] iFieldArray = fields = type.getFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    IField field = iFieldArray[n2];
                    list.add(field.getElementName());
                    ++n2;
                }
            }
        }
        catch (JavaModelException e) {
            Logger.logError("Error while retrieving fields for " + className, e);
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] getArguments(String methodName, String className) {
        ArrayList list = new ArrayList();
        try {
            IMethod method = JavaUtil.getMethodFor(className, methodName);
            if (method != null) {
                return method.getParameterNames();
            }
        }
        catch (JavaModelException e) {
            Logger.logError("Error while retrieving arguments for " + className + "." + methodName, e);
        }
        return list.toArray(new String[list.size()]);
    }
}

