/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.common.wrapper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.jboss.tools.flow.common.model.Element;
import org.jboss.tools.flow.common.wrapper.ModelEvent;
import org.jboss.tools.flow.common.wrapper.ModelListener;
import org.jboss.tools.flow.common.wrapper.Wrapper;

public abstract class AbstractWrapper
implements Wrapper {
    private Element element;
    private transient List<ModelListener> listeners = new ArrayList<ModelListener>();

    public void setElement(Element element) {
        this.element = element;
    }

    public Element getElement() {
        return this.element;
    }

    public void addListener(ModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ModelListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyListeners(int change, Object object) {
        ModelEvent event = new ModelEvent(change, object);
        for (ModelListener listener : this.listeners) {
            listener.modelChanged(event);
        }
    }

    public void notifyListeners(int change) {
        this.notifyListeners(change, null);
    }

    public Object getEditableValue() {
        if (this.getPropertySource() != null) {
            this.getPropertySource().getEditableValue();
        }
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.getPropertySource() != null) {
            return this.getPropertySource().getPropertyDescriptors();
        }
        return null;
    }

    public Object getPropertyValue(Object id) {
        if (this.getPropertySource() != null) {
            return this.getPropertySource().getPropertyValue(id);
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        if (this.getPropertySource() != null) {
            return this.getPropertySource().isPropertySet(id);
        }
        return false;
    }

    public void resetPropertyValue(Object id) {
        if (this.getPropertySource() != null) {
            this.getPropertySource().resetPropertyValue(id);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (this.getPropertySource() != null) {
            this.getPropertySource().setPropertyValue(id, value);
            this.notifyListeners(8, id);
        }
    }

    protected abstract IPropertySource getPropertySource();

    public Object getAdapter(Class adapter) {
        if (adapter == Element.class) {
            return this.element;
        }
        return null;
    }
}

