/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.common.wrapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.tools.flow.common.wrapper.AbstractWrapper;
import org.jboss.tools.flow.common.wrapper.FlowWrapper;
import org.jboss.tools.flow.common.wrapper.ModelEvent;
import org.jboss.tools.flow.common.wrapper.ModelListener;
import org.jboss.tools.flow.common.wrapper.NodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFlowWrapper
extends AbstractWrapper
implements FlowWrapper {
    private Map<String, NodeWrapper> elementMap = new HashMap<String, NodeWrapper>();
    private List<NodeWrapper> elementList = new ArrayList<NodeWrapper>();
    private transient List<ModelListener> listeners = new ArrayList<ModelListener>();

    @Override
    public abstract Integer getRouterLayout();

    public void setRouterLayout(Integer routerLayout) {
        this.internalSetRouterLayout(routerLayout);
        this.notifyListeners(5, null);
    }

    protected void internalSetRouterLayout(Integer routerLayout) {
    }

    @Override
    public List<NodeWrapper> getElements() {
        return Collections.unmodifiableList(new ArrayList<NodeWrapper>(this.elementList));
    }

    @Override
    public NodeWrapper getElement(String id) {
        return this.elementMap.get(id);
    }

    @Override
    public void addElement(NodeWrapper element) {
        if (!this.acceptsElement(element)) {
            return;
        }
        this.internalAddElement(element);
        this.localAddElement(element);
        this.notifyListeners(6, element);
    }

    @Override
    public void localAddElement(NodeWrapper element) {
        this.elementMap.put(element.getId(), element);
        this.elementList.add(element);
        element.setParent(this);
    }

    @Override
    public boolean acceptsElement(NodeWrapper element) {
        return true;
    }

    protected abstract void internalAddElement(NodeWrapper var1);

    public void localRemoveElement(NodeWrapper element) {
        this.elementMap.remove(element.getId());
        this.elementList.remove(element);
    }

    @Override
    public void removeElement(NodeWrapper element) {
        this.localRemoveElement(element);
        this.internalRemoveElement(element);
        this.notifyListeners(7, element);
    }

    protected abstract void internalRemoveElement(NodeWrapper var1);

    @Override
    public FlowWrapper getFlowWrapper() {
        return this;
    }

    @Override
    public void addListener(ModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ModelListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyListeners(int change, NodeWrapper wrapper) {
        ModelEvent event = new ModelEvent(change, wrapper);
        for (ModelListener listener : this.listeners) {
            listener.modelChanged(event);
        }
    }
}

