/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.flow.common.editpart;

import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.tools.DirectEditManager;
import org.jboss.tools.flow.common.editpart.CellEditorLocator;
import org.jboss.tools.flow.common.figure.ElementFigure;
import org.jboss.tools.flow.common.policy.ElementDirectEditManager;
import org.jboss.tools.flow.common.policy.ElementDirectEditPolicy;
import org.jboss.tools.flow.common.policy.ElementEditPolicy;
import org.jboss.tools.flow.common.policy.ElementNodeEditPolicy;
import org.jboss.tools.flow.common.wrapper.ConnectionWrapper;
import org.jboss.tools.flow.common.wrapper.ModelEvent;
import org.jboss.tools.flow.common.wrapper.ModelListener;
import org.jboss.tools.flow.common.wrapper.NodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementEditPart
extends AbstractGraphicalEditPart
implements NodeEditPart,
ModelListener {
    private DirectEditManager manager;

    public NodeWrapper getElementWrapper() {
        return (NodeWrapper)this.getModel();
    }

    public ElementFigure getElementFigure() {
        return (ElementFigure)this.getFigure();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ElementNodeEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ElementEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ElementDirectEditPolicy());
    }

    protected List<ConnectionWrapper> getModelSourceConnections() {
        return this.getElementWrapper().getOutgoingConnections();
    }

    protected List<ConnectionWrapper> getModelTargetConnections() {
        return this.getElementWrapper().getIncomingConnections();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.getElementFigure().getSourceConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.getElementFigure().getTargetConnectionAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.getElementFigure().getSourceConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getElementFigure().getTargetConnectionAnchor();
    }

    protected void refreshVisuals() {
        NodeWrapper element = this.getElementWrapper();
        ElementFigure figure = (ElementFigure)this.getFigure();
        figure.setText(element.getName());
        if (element.getConstraint().width == -1) {
            element.getConstraint().width = figure.getBounds().width;
        }
        if (element.getConstraint().height == -1) {
            element.getConstraint().height = figure.getBounds().height;
        }
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, (IFigure)figure, (Object)element.getConstraint());
    }

    @Override
    public void modelChanged(ModelEvent event) {
        if (event.getChange() == 1) {
            this.refreshTargetConnections();
        } else if (event.getChange() == 2) {
            this.refreshTargetConnections();
        } else if (event.getChange() == 3) {
            this.refreshSourceConnections();
        } else if (event.getChange() == 4) {
            this.refreshSourceConnections();
        } else if (event.getChange() == 5) {
            this.refreshVisuals();
        }
    }

    public void activate() {
        super.activate();
        this.getElementWrapper().addListener(this);
    }

    public void deactivate() {
        this.getElementWrapper().removeListener(this);
        super.deactivate();
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            this.performDirectEdit();
        }
        if (request.getType() == "open") {
            this.doubleClicked();
        } else {
            super.performRequest(request);
        }
    }

    protected void doubleClicked() {
    }

    protected void performDirectEdit() {
        Label label = ((ElementFigure)this.getFigure()).getLabel();
        if (label == null) {
            return;
        }
        if (this.manager == null) {
            this.manager = new ElementDirectEditManager((GraphicalEditPart)this, new CellEditorLocator(label));
        }
        this.manager.show();
    }
}

