/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.console.forms;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import org.jboss.bpm.console.server.plugin.FormAuthorityRef;
import org.jboss.bpm.console.server.plugin.FormDispatcherPlugin;
import org.jbpm.api.Execution;
import org.jbpm.api.ExecutionService;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.api.RepositoryService;
import org.jbpm.api.TaskService;
import org.jbpm.api.task.Task;
import org.jbpm.integration.console.forms.AbstractFormDispatcher;
import org.jbpm.integration.console.forms.FormDirective;
import org.jbpm.integration.console.forms.OutcomeDirective;

public class TaskFormDispatcher
extends AbstractFormDispatcher
implements FormDispatcherPlugin {
    public URL getDispatchUrl(FormAuthorityRef ref) {
        if (!this.taskHasForm(ref.getReferenceId())) {
            return null;
        }
        StringBuilder baseUrl = this.getBaseUrl();
        baseUrl.append("/form/task/");
        baseUrl.append(ref.getReferenceId());
        baseUrl.append("/render");
        try {
            return new URL(baseUrl.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to resolve task dispatch url", e);
        }
    }

    private boolean taskHasForm(String id) {
        boolean result = false;
        TaskService taskService = this.processEngine.getTaskService();
        Task task = taskService.getTask(id);
        result = task.getFormResourceName() != null;
        return result;
    }

    public DataHandler provideForm(FormAuthorityRef ref) {
        TaskService taskService = this.processEngine.getTaskService();
        ExecutionService executionService = this.processEngine.getExecutionService();
        RepositoryService repoService = this.processEngine.getRepositoryService();
        Task task = taskService.getTask(ref.getReferenceId());
        String executionId = task.getExecutionId();
        Execution execution = executionService.findExecutionById(executionId);
        String procInstId = execution.getProcessInstance().getId();
        ProcessDefinition procDef = repoService.createProcessDefinitionQuery().processDefinitionId(execution.getProcessDefinitionId()).uniqueResult();
        String name = task.getFormResourceName();
        InputStream template = repoService.getResourceAsStream(procDef.getDeploymentId(), name);
        if (template == null) {
            throw new IllegalArgumentException("Task form resource '" + name + "' doesn't exist.");
        }
        Map processContext = new HashMap();
        ExecutionService execService = this.processEngine.getExecutionService();
        Set varNames = execService.getVariableNames(procInstId);
        if (varNames != null) {
            processContext = execService.getVariables(procInstId, varNames);
        }
        StringBuilder action = this.getBaseUrl();
        action.append("/form/task/");
        action.append(ref.getReferenceId());
        action.append("/complete");
        HashMap<String, Object> renderContext = new HashMap<String, Object>();
        FormDirective formDirective = new FormDirective();
        formDirective.setAction(action.toString());
        renderContext.put("form", formDirective);
        OutcomeDirective outcomeDirective = new OutcomeDirective();
        Set outcomes = taskService.getOutcomes(task.getId());
        for (String outcome : outcomes) {
            outcomeDirective.getValues().add(outcome);
        }
        renderContext.put("outcome", outcomeDirective);
        InputStream css = this.loadCSS(task.getExecutionId());
        if (css != null) {
            renderContext.put("CSS", this.streamToString(css));
        }
        renderContext.putAll(processContext);
        DataHandler result = this.processTemplate(name, template, renderContext);
        return result;
    }

    private InputStream loadCSS(String executionId) {
        RepositoryService repoService = this.processEngine.getRepositoryService();
        ExecutionService execService = this.processEngine.getExecutionService();
        Execution execution = execService.findExecutionById(executionId);
        if (execution != null) {
            ProcessDefinition definition = repoService.createProcessDefinitionQuery().processDefinitionId(execution.getProcessDefinitionId()).uniqueResult();
            InputStream in = repoService.getResourceAsStream(definition.getDeploymentId(), "process_forms.css");
            return in;
        }
        return null;
    }
}

