/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.console.forms;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import org.jboss.bpm.console.server.plugin.FormAuthorityRef;
import org.jboss.bpm.console.server.plugin.FormDispatcherPlugin;
import org.jbpm.api.ExecutionService;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.api.ProcessDefinitionQuery;
import org.jbpm.api.RepositoryService;
import org.jbpm.api.TaskService;
import org.jbpm.api.task.Task;
import org.jbpm.integration.console.forms.AbstractFormDispatcher;
import org.jbpm.integration.console.forms.FormDirective;
import org.jbpm.integration.console.forms.OutcomeDirective;
import org.jbpm.pvm.internal.env.Environment;
import org.jbpm.pvm.internal.env.EnvironmentFactory;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.Transition;
import org.jbpm.pvm.internal.task.TaskImpl;

public class TaskFormDispatcher
extends AbstractFormDispatcher
implements FormDispatcherPlugin {
    public URL getDispatchUrl(FormAuthorityRef ref) {
        if (!this.taskHasForm(ref.getReferenceId())) {
            return null;
        }
        StringBuilder baseUrl = this.getBaseUrl();
        baseUrl.append("/form/task/");
        baseUrl.append(ref.getReferenceId());
        baseUrl.append("/render");
        try {
            return new URL(baseUrl.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to resolve task dispatch url", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean taskHasForm(String id) {
        boolean result = false;
        Environment env = ((EnvironmentFactory)this.processEngine).openEnvironment();
        try {
            TaskService taskService = this.processEngine.getTaskService();
            Task task = taskService.getTask(id);
            result = task.getFormResourceName() != null;
        }
        finally {
            env.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataHandler provideForm(FormAuthorityRef ref) {
        Environment env = ((EnvironmentFactory)this.processEngine).openEnvironment();
        try {
            DataHandler result;
            TaskService taskService = this.processEngine.getTaskService();
            Task task = taskService.getTask(ref.getReferenceId());
            TaskImpl cast = (TaskImpl)task;
            ExecutionImpl processInstance = cast.getProcessInstance();
            String processInstanceId = processInstance.getId();
            String processId = processInstance.getProcessDefinition().getId();
            RepositoryService repoService = this.processEngine.getRepositoryService();
            ProcessDefinitionQuery query = repoService.createProcessDefinitionQuery();
            query.processDefinitionId(processId);
            ProcessDefinition procDef = query.uniqueResult();
            String name = task.getFormResourceName();
            InputStream template = repoService.getResourceAsStream(procDef.getDeploymentId(), name);
            if (template == null) {
                throw new IllegalArgumentException("Task form resource '" + name + "' doesn't exist.");
            }
            Map processContext = new HashMap();
            ExecutionService execService = this.processEngine.getExecutionService();
            Set varNames = execService.getVariableNames(processInstanceId);
            if (varNames != null) {
                processContext = execService.getVariables(processInstanceId, varNames);
            }
            StringBuilder action = this.getBaseUrl();
            action.append("/form/task/");
            action.append(ref.getReferenceId());
            action.append("/complete");
            HashMap<String, Object> renderContext = new HashMap<String, Object>();
            FormDirective formDirective = new FormDirective();
            formDirective.setAction(action.toString());
            renderContext.put("form", formDirective);
            OutcomeDirective outcomeDirective = new OutcomeDirective();
            List transitions = processInstance.getActivity().getOutgoingTransitions();
            for (Transition t : transitions) {
                String outcomeName = t.getName() != null ? t.getName() : "to_" + t.getDestination().getName();
                outcomeDirective.getValues().add(outcomeName);
            }
            renderContext.put("outcome", outcomeDirective);
            renderContext.putAll(processContext);
            DataHandler dataHandler = result = this.processTemplate(name, template, renderContext);
            return dataHandler;
        }
        finally {
            env.close();
        }
    }
}

