/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.console.forms;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.naming.InitialContext;
import org.jboss.bpm.console.server.plugin.TaskDispatcherPlugin;
import org.jbpm.api.ExecutionService;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.api.ProcessDefinitionQuery;
import org.jbpm.api.ProcessEngine;
import org.jbpm.api.RepositoryService;
import org.jbpm.api.TaskService;
import org.jbpm.api.env.Environment;
import org.jbpm.api.env.EnvironmentFactory;
import org.jbpm.api.model.Transition;
import org.jbpm.api.task.Task;
import org.jbpm.integration.console.forms.FormDirective;
import org.jbpm.integration.console.forms.OutcomeDirective;
import org.jbpm.integration.spi.mgmt.ServerConfig;
import org.jbpm.integration.spi.mgmt.ServerConfigFactory;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.task.TaskImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDispatcherPluginImpl
implements TaskDispatcherPlugin {
    private ProcessEngine processEngine;
    private ServerConfig serverConfig = null;

    public TaskDispatcherPluginImpl() {
        this.initializeProcessEngine();
    }

    public URL getDispatchUrl(long taskId) {
        StringBuilder spec = new StringBuilder();
        spec.append("http://");
        spec.append(this.getServerConfig().getWebServiceHost());
        spec.append(":").append(this.getServerConfig().getWebServicePort());
        spec.append("/gwt-console-server/rs/task/");
        spec.append(taskId);
        spec.append("/render");
        try {
            return new URL(spec.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to resolve task dispatch url", e);
        }
    }

    private ServerConfig getServerConfig() {
        if (null == this.serverConfig) {
            this.serverConfig = ServerConfigFactory.getServerConfig();
        }
        return this.serverConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataHandler provideTaskUI(long taskId) {
        Environment env = ((EnvironmentFactory)this.processEngine).openEnvironment();
        DataHandler result = null;
        try {
            ExecutionService execService;
            Set varNames;
            TaskService taskService = this.processEngine.getTaskService();
            Task task = taskService.getTask(taskId);
            TaskImpl cast = (TaskImpl)task;
            ExecutionImpl processInstance = cast.getProcessInstance();
            String processInstanceId = processInstance.getId();
            String processId = processInstance.getProcessDefinition().getId();
            RepositoryService repoService = this.processEngine.getRepositoryService();
            ProcessDefinitionQuery query = repoService.createProcessDefinitionQuery();
            query.processDefinitionId(processId);
            ProcessDefinition procDef = query.uniqueResult();
            String name = task.getName() + ".ftl";
            InputStream template = repoService.getResourceAsStream(procDef.getDeploymentDbid(), name);
            if (template != null && (varNames = (execService = this.processEngine.getExecutionService()).getVariableNames(processInstanceId)) != null) {
                Map processContext = execService.getVariables(processInstanceId, varNames);
                StringBuilder action = new StringBuilder();
                action.append("http://");
                action.append(this.getServerConfig().getWebServiceHost());
                action.append(":").append(this.getServerConfig().getWebServicePort());
                action.append("/gwt-console-server/rs/task/");
                action.append(taskId);
                action.append("/process");
                HashMap<String, Object> renderContext = new HashMap<String, Object>();
                FormDirective formDirective = new FormDirective();
                formDirective.setAction(action.toString());
                renderContext.put("form", formDirective);
                OutcomeDirective outcomeDirective = new OutcomeDirective();
                List transitions = processInstance.getActivity().getOutgoingTransitions();
                for (Transition t : transitions) {
                    String outcomeName = t.getName() != null ? t.getName() : "to_" + t.getDestination().getName();
                    outcomeDirective.getValues().add(outcomeName);
                }
                renderContext.put("outcome", outcomeDirective);
                renderContext.putAll(processContext);
                result = this.processTemplate(name, template, renderContext);
            }
            DataHandler dataHandler = result;
            return dataHandler;
        }
        finally {
            env.close();
        }
    }

    private DataHandler processTemplate(final String name, InputStream src, Map<String, Object> renderContext) {
        DataHandler merged = null;
        try {
            Configuration cfg = new Configuration();
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            cfg.setTemplateUpdateDelay(0);
            Template temp = new Template(name, (Reader)new InputStreamReader(src), cfg);
            temp.dump(System.out);
            final ByteArrayOutputStream bout = new ByteArrayOutputStream();
            OutputStreamWriter out = new OutputStreamWriter(bout);
            temp.process(renderContext, (Writer)out);
            ((Writer)out).flush();
            merged = new DataHandler(new DataSource(){

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(bout.toByteArray());
                }

                public OutputStream getOutputStream() throws IOException {
                    return bout;
                }

                public String getContentType() {
                    return "*/*";
                }

                public String getName() {
                    return name + "_DataSource";
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process task template", e);
        }
        return merged;
    }

    public void processCompletion(long taskId, String outcome, InputStream payload) {
    }

    protected void initializeProcessEngine() {
        try {
            InitialContext ctx = new InitialContext();
            this.processEngine = (ProcessEngine)ctx.lookup("java:/ProcessEngine");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to lookup process engine", e);
        }
    }
}

