/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.console.forms;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.integration.console.forms.FormDirective;
import org.jbpm.integration.console.forms.OutcomeDirective;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Runner {
    static String template = "<html>\n<body>\n\n<h2>Please enter your name</h2>\n<form action=\"${form.action}\" method=\"POST\" enctype=\"multipart/form-data\">\n<input type=\"text\" name=\"name\" value=\"\"><br/>\nOutcomes:<br/>\n<ul>\n<#list outcome.values as transition>\n  <li>${transition}  \n</#list>\n</ul> \n<input type=\"submit\">\n</form>\n</body>\n</html>";

    public static void main(String[] args) {
        Runner r = new Runner();
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        FormDirective f = new FormDirective("http://localhost:8080/");
        OutcomeDirective o = new OutcomeDirective();
        o.getValues().add("transition1");
        o.getValues().add("transition2");
        ctx.put("form", f);
        ctx.put("outcome", o);
        r.execute(ctx, "testRun", new ByteArrayInputStream(template.getBytes()));
    }

    private void execute(Map<String, Object> renderContext, String name, InputStream src) {
        try {
            Configuration cfg = new Configuration();
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            cfg.setTemplateUpdateDelay(0);
            Template temp = new Template(name, (Reader)new InputStreamReader(src), cfg);
            temp.dump(System.out);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            OutputStreamWriter out = new OutputStreamWriter(bout);
            temp.process(renderContext, (Writer)out);
            ((Writer)out).flush();
            System.out.println(new String(bout.toByteArray()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

