/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.integration.console.forms;

import freemarker.template.DefaultObjectWrapper;
import freemarker.template.Template;

import java.io.*;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class Runner
{
  static String template = "<html>\n" +
      "<body>\n" +
      "\n" +
      "<h2>Please enter your name</h2>\n" +
      "<form action=\"${form.action}\" method=\"POST\" enctype=\"multipart/form-data\">\n" +
      "<input type=\"text\" name=\"name\" value=\"\"><br/>\n" +
      "Outcomes:<br/>\n" +
      "<ul>\n" +
      "<#list outcome.values as transition>\n" +
      "  <li>${transition}  \n" +
      "</#list>\n" +
      "</ul> \n" +
      "<input type=\"submit\">\n" +
      "</form>\n" +
      "</body>\n" +
      "</html>";

  public static void main(String[] args)
  {
    Runner r = new Runner();

    Map<String,Object> ctx = new HashMap<String,Object>();
    FormDirective f = new FormDirective("http://localhost:8080/");
    OutcomeDirective o = new OutcomeDirective();
    o.getValues().add("transition1");
    o.getValues().add("transition2");

    ctx.put("form", f);
    ctx.put("outcome", o);

    r.execute(ctx, "testRun", new ByteArrayInputStream(template.getBytes()));
  }

  private void execute(Map<String, Object> renderContext, String name, InputStream src)
  {
    try
    {
      freemarker.template.Configuration cfg = new freemarker.template.Configuration();
      cfg.setObjectWrapper(new DefaultObjectWrapper());
      cfg.setTemplateUpdateDelay(0);

      Template temp = new Template(name, new InputStreamReader(src), cfg);
      temp.dump(System.out);
      
      final ByteArrayOutputStream bout = new ByteArrayOutputStream();
      Writer out = new OutputStreamWriter(bout);
      temp.process(renderContext, out);
      out.flush();

      System.out.println(new String(bout.toByteArray()));
    }
    catch (Exception e)
    {
      throw new RuntimeException(e);
    }   
  }


}
