/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.impl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.identity.hibernate.IdentitySession;
import org.jbpm.jsf.JbpmJsfContext;
import org.jbpm.jsf.core.config.ConfigurationLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JbpmJsfContextImpl
implements JbpmJsfContext {
    private JbpmContext jbpmContext;
    private IdentitySession identitySession;
    private List<FacesMessage> messages = new ArrayList<FacesMessage>();
    private String outcome;
    private boolean error;
    private String actionName;
    private String outcomeActionName;
    private boolean enableNavigation;
    private static final Logger log = Logger.getLogger("org.jbpm.jsf.core.impl.JbpmJsfContextImpl");

    public boolean hasJbpmContext() {
        return this.jbpmContext != null;
    }

    @Override
    public JbpmContext getJbpmContext() {
        boolean debug = log.isLoggable(Level.FINE);
        if (this.jbpmContext == null) {
            this.jbpmContext = JbpmConfiguration.getInstance().createJbpmContext();
            Principal userPrincipal = FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal();
            if (userPrincipal != null && ConfigurationLocator.getInstance().useJsfActorId()) {
                this.jbpmContext.setActorId(userPrincipal.getName());
            }
            if (debug) {
                log.fine(String.valueOf(this.toString()) + " using NEW " + this.jbpmContext.toString());
            }
        } else if (debug) {
            log.fine(String.valueOf(this.toString()) + " using cached " + this.jbpmContext.toString());
        }
        return this.jbpmContext;
    }

    @Override
    public IdentitySession getIdentitySession() {
        if (this.identitySession == null) {
            this.identitySession = new IdentitySession(this.getJbpmContext().getSession());
        }
        return this.identitySession;
    }

    @Override
    public void addSuccessMessage(String message) {
        if (message != null) {
            this.messages.add(new FacesMessage(message, null));
            if (log.isLoggable(Level.FINE)) {
                log.fine("Added success message: " + message);
            }
        }
    }

    @Override
    public void addSuccessMessage(String message, String detail) {
        if (message != null) {
            this.messages.add(new FacesMessage(message, detail));
            if (log.isLoggable(Level.FINE)) {
                log.fine("Added success message: " + message + " (detail: " + detail + ")");
            }
        }
    }

    @Override
    public void addSuccessMessage(FacesMessage.Severity severity, String message, String detail) {
        if (severity == null) {
            throw new NullPointerException("addSuccessMessage cannot accept null as the value of the severity parameter");
        }
        if (message != null) {
            this.messages.add(new FacesMessage(severity, message, detail));
            if (log.isLoggable(Level.FINE)) {
                log.fine("Added success message: severity " + severity + ", message: " + message + " (detail: " + detail + ")");
            }
        }
    }

    @Override
    public void selectOutcome(String outcomeName) {
        if (outcomeName != null && this.enableNavigation) {
            this.outcome = outcomeName;
            this.outcomeActionName = this.actionName;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Selected outcome " + outcomeName);
            }
        }
    }

    @Override
    public String getOutcome() {
        return this.outcome;
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    @Override
    public void setError(String message) {
        this.error = true;
        if (message != null) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, message, null));
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Error message \"" + message + "\"");
        }
    }

    @Override
    public void setError(String message, String detail) {
        this.error = true;
        if (message != null) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, message, detail));
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Error message \"" + message + "\" (" + detail + ")");
        }
    }

    @Override
    public void setError(String message, Throwable cause) {
        this.error = true;
        StringBuilder detailBuilder = new StringBuilder();
        detailBuilder.append("An exception of type \"");
        detailBuilder.append(cause.getClass().getName());
        detailBuilder.append("\" was thrown.");
        String exMsg = cause.getMessage();
        if (exMsg != null) {
            detailBuilder.append("  The message is: ");
            detailBuilder.append(exMsg);
        }
        if (message != null) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, message, detailBuilder.toString()));
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Error message \"" + message + "\" (exception thrown: " + cause.getMessage() + ")", cause);
        }
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public String getOutcomeActionName() {
        return this.outcomeActionName;
    }

    public void setEnableNavigation(boolean enableNavigation) {
        this.enableNavigation = enableNavigation;
    }

    public void reset() {
        this.messages = new ArrayList<FacesMessage>();
        this.error = false;
        this.outcome = null;
        this.outcomeActionName = null;
        this.actionName = null;
    }

    public List<FacesMessage> getMessages() {
        return this.messages;
    }
}

