/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.handler;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.el.VariableMapperWrapper;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagException;
import com.sun.facelets.tag.TagHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.jbpm.file.def.FileDefinition;
import org.jbpm.graph.def.ProcessDefinition;

public final class IncludeProcessFileHandler
extends TagHandler {
    private final TagAttribute processAttribute = this.getRequiredAttribute("process");
    private final TagAttribute fileAttribute = this.getRequiredAttribute("file");

    public IncludeProcessFileHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        ValueExpression fileExpression = this.fileAttribute.getValueExpression(ctx, String.class);
        ValueExpression processExpression = this.processAttribute.getValueExpression(ctx, ProcessDefinition.class);
        String file = (String)fileExpression.getValue((ELContext)ctx);
        if (file == null || file.length() == 0) {
            return;
        }
        ProcessDefinition processDefinition = (ProcessDefinition)processExpression.getValue((ELContext)ctx);
        if (processDefinition == null) {
            throw new TagException(this.tag, "Value for process attribute is null");
        }
        FileDefinition fileDefinition = processDefinition.getFileDefinition();
        if (fileDefinition == null) {
            throw new TagException(this.tag, "Process has a null fileDefinition property");
        }
        if (!fileDefinition.hasFile(file)) {
            throw new TagException(this.tag, "Process does not contain file '" + file + "'");
        }
        VariableMapper orig = ctx.getVariableMapper();
        VariableMapperWrapper newVarMapper = new VariableMapperWrapper(orig);
        ctx.setVariableMapper((VariableMapper)newVarMapper);
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append(processDefinition.getId());
            buffer.append("/");
            buffer.append(file);
            this.nextHandler.apply(ctx, parent);
            ctx.includeFacelet(parent, new URL("par", "", 0, buffer.toString(), new FileDefinitionURLStreamHandler(fileDefinition, file)));
        }
        finally {
            ctx.setVariableMapper(orig);
        }
    }

    private static final class FileDefinitionURLConnection
    extends URLConnection {
        private final FileDefinition fileDefinition;
        private final String src;

        protected FileDefinitionURLConnection(URL url, FileDefinition fileDefinition, String src) {
            super(url);
            this.fileDefinition = fileDefinition;
            this.src = src;
        }

        public void connect() {
        }

        public InputStream getInputStream() throws FileNotFoundException {
            InputStream inputStream = this.fileDefinition.getInputStream(this.src);
            if (inputStream == null) {
                throw new FileNotFoundException("File '" + this.src + "' not found in process file definition");
            }
            return inputStream;
        }
    }

    private static final class FileDefinitionURLStreamHandler
    extends URLStreamHandler {
        private final FileDefinition fileDefinition;
        private final String src;

        public FileDefinitionURLStreamHandler(FileDefinition fileDefinition, String src) {
            this.fileDefinition = fileDefinition;
            this.src = src;
        }

        protected URLConnection openConnection(URL url) {
            return new FileDefinitionURLConnection(url, this.fileDefinition, this.src);
        }
    }
}

