/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;

public final class DeployProcessActionListener
implements JbpmActionListener {
    private final ValueExpression archiveExpression;
    private final ValueExpression targetExpression;
    private static final Logger log = Logger.getLogger("org.jbpm.jsf.core.handler.DeployProcessActionHandler");

    public DeployProcessActionListener(ValueExpression archiveExpression, ValueExpression targetExpression) {
        this.archiveExpression = archiveExpression;
        this.targetExpression = targetExpression;
    }

    public String getName() {
        return "deployProcess";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            ProcessDefinition processDefinition;
            InputStream inputStream;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object archiveValue = this.archiveExpression.getValue(elContext);
            if (archiveValue == null) {
                context.setError("Error deploying process", "Archive is null");
                return;
            }
            if (archiveValue instanceof InputStream) {
                inputStream = (InputStream)archiveValue;
            } else if (archiveValue instanceof byte[]) {
                byte[] bytes = (byte[])archiveValue;
                inputStream = new ByteArrayInputStream(bytes);
            } else {
                context.setError("Error deploying process", "Type of 'archive' attribute is not recognized");
                return;
            }
            try {
                ZipInputStream zis = new ZipInputStream(inputStream);
                try {
                    processDefinition = ProcessDefinition.parseParZipInputStream((ZipInputStream)zis);
                    JbpmContext jbpmContext = context.getJbpmContext();
                    jbpmContext.deployProcessDefinition(processDefinition);
                }
                finally {
                    try {
                        zis.close();
                    }
                    catch (IOException e) {
                        log.warning("Error closing zip Ninput stream after deploy: " + e.getMessage());
                    }
                }
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.warning("Error closing input stream after deploy: " + e.getMessage());
                }
            }
            context.addSuccessMessage("New process deployed");
            context.getJbpmContext().getSession().flush();
            if (this.targetExpression != null) {
                this.targetExpression.setValue(elContext, (Object)processDefinition);
            }
            context.selectOutcome("success");
        }
        catch (Exception ex) {
            context.setError("Error deploying process", ex);
            return;
        }
    }
}

