/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.identity.action;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.identity.hibernate.IdentitySession;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;

public final class VerifyUserActionListener
implements JbpmActionListener {
    private final ValueExpression userNameExpression;
    private final ValueExpression passwordExpression;
    private final ValueExpression userIdTargetExpression;

    public VerifyUserActionListener(ValueExpression userNameExpression, ValueExpression passwordExpression, ValueExpression userIdTargetExpression) {
        this.userNameExpression = userNameExpression;
        this.passwordExpression = passwordExpression;
        this.userIdTargetExpression = userIdTargetExpression;
    }

    public String getName() {
        return "verifyUser";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            IdentitySession identitySession = new IdentitySession(context.getJbpmContext().getSession());
            Object userNameValue = this.userNameExpression.getValue(elContext);
            if (userNameValue == null) {
                context.setError("Error verifying user", "User name is null");
                return;
            }
            Object passwordValue = this.passwordExpression.getValue(elContext);
            if (passwordValue == null) {
                context.setError("Error verifying user", "Password is null");
                return;
            }
            Long id = identitySession.verify(userNameValue.toString(), passwordValue.toString());
            if (id == null) {
                context.setError("Invalid user name or password");
                return;
            }
            if (this.userIdTargetExpression != null) {
                this.userIdTargetExpression.setValue(elContext, (Object)id);
            }
            context.selectOutcome("success");
        }
        catch (Exception ex) {
            context.setError("Error verifying user", ex);
            return;
        }
    }
}

