/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import java.util.Date;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;
import org.jbpm.taskmgmt.exe.TaskInstance;

public final class UpdateTaskStartActionListener
implements JbpmActionListener {
    private final ValueExpression taskExpression;
    private final ValueExpression startDateExpression;

    public UpdateTaskStartActionListener(ValueExpression startDateExpression, ValueExpression taskExpression) {
        this.startDateExpression = startDateExpression;
        this.taskExpression = taskExpression;
    }

    public String getName() {
        return "updateTaskStart";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            Date start;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object taskInstanceValue = this.taskExpression.getValue(elContext);
            if (taskInstanceValue == null) {
                context.setError("Error updating task", "The task instance value is null");
                return;
            }
            if (!(taskInstanceValue instanceof TaskInstance)) {
                context.setError("Error updating task", "Attempted to resume something other than a task instance");
                return;
            }
            TaskInstance taskInstance = (TaskInstance)taskInstanceValue;
            if (this.startDateExpression != null) {
                Object startDateValue = this.startDateExpression.getValue(elContext);
                if (startDateValue == null) {
                    context.setError("Error updating task", "Start date value is null");
                    return;
                }
                if (startDateValue instanceof Date) {
                    start = (Date)startDateValue;
                } else {
                    if (!(startDateValue instanceof Long)) {
                        context.setError("Error updating task", "Start date value is not a recognized type");
                        return;
                    }
                    start = new Date((Long)startDateValue);
                }
            } else {
                start = new Date();
            }
            taskInstance.setStart(start);
            context.getJbpmContext().getSession().flush();
            return;
        }
        catch (Exception ex) {
            context.setError("Error updating task", ex);
            return;
        }
    }
}

