/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;
import org.jbpm.jsf.taskform.ui.UITaskFormCancelButton;
import org.jbpm.jsf.taskform.ui.UITaskFormSaveButton;
import org.jbpm.jsf.taskform.ui.UITaskFormTransitionButton;

public final class TaskFormButtonActionListener
implements JbpmActionListener {
    private final ValueExpression transitionTargetValueExpression;
    private final ValueExpression buttonTargetValueExpression;
    private static final Logger log = Logger.getLogger("org.jbpm.jsf.core.action.TaskFormButtonActionListener");

    public TaskFormButtonActionListener(ValueExpression transitionTargetValueExpression, ValueExpression buttonTargetValueExpression) {
        this.transitionTargetValueExpression = transitionTargetValueExpression;
        this.buttonTargetValueExpression = buttonTargetValueExpression;
    }

    public String getName() {
        return "taskFormButton";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        UIComponent source = event.getComponent();
        ELContext elContext = FacesContext.getCurrentInstance().getELContext();
        if (source instanceof UITaskFormCancelButton) {
            context.selectOutcome("cancel");
            if (this.buttonTargetValueExpression != null) {
                this.buttonTargetValueExpression.setValue(elContext, (Object)"cancel");
            }
            log.fine("Cancel button selected");
        } else if (source instanceof UITaskFormSaveButton) {
            context.selectOutcome("save");
            if (this.buttonTargetValueExpression != null) {
                this.buttonTargetValueExpression.setValue(elContext, (Object)"save");
            }
            log.fine("Save button selected");
        } else if (source instanceof UITaskFormTransitionButton) {
            if (this.transitionTargetValueExpression != null) {
                String transitionName = ((UITaskFormTransitionButton)source).getTransition();
                this.transitionTargetValueExpression.setValue(elContext, (Object)transitionName);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Updating transition expression '" + this.transitionTargetValueExpression.getExpressionString() + "' with transition value '" + transitionName + "'");
                }
            }
            if (this.buttonTargetValueExpression != null) {
                this.buttonTargetValueExpression.setValue(elContext, (Object)"transition");
            }
            log.fine("Transition button selected");
            context.selectOutcome("transition");
        }
    }
}

