/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jsf.core.action;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.PhaseId;
import org.jbpm.graph.exe.Token;
import org.jbpm.jsf.JbpmActionListener;
import org.jbpm.jsf.JbpmJsfContext;

public final class LoadTokenActionListener
implements JbpmActionListener {
    private final ValueExpression idExpression;
    private final ValueExpression targetExpression;
    private final ValueExpression forUpdateExpression;

    public LoadTokenActionListener(ValueExpression idExpression, ValueExpression targetExpression, ValueExpression forUpdateExpression) {
        this.idExpression = idExpression;
        this.targetExpression = targetExpression;
        this.forUpdateExpression = forUpdateExpression;
    }

    public String getName() {
        return "loadProcessInstance";
    }

    public void handleAction(JbpmJsfContext context, ActionEvent event) {
        try {
            boolean forUpdate;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object idValue = this.idExpression.getValue(elContext);
            if (idValue == null) {
                context.setError("Error loading token", "The ID value is null");
                return;
            }
            long id = idValue instanceof Long ? ((Long)idValue).longValue() : Long.valueOf(idValue.toString()).longValue();
            if (this.forUpdateExpression != null) {
                Object forUpdateValue = this.forUpdateExpression.getValue(elContext);
                if (forUpdateValue == null) {
                    context.setError("Error loading token", "The value of 'forUpdate' is null");
                    return;
                }
                forUpdate = forUpdateValue instanceof Boolean ? (Boolean)forUpdateValue : Boolean.parseBoolean(forUpdateValue.toString());
            } else {
                forUpdate = event.getPhaseId() != PhaseId.RENDER_RESPONSE;
            }
            Token token = forUpdate ? context.getJbpmContext().getTokenForUpdate(id) : context.getJbpmContext().getToken(id);
            if (token == null) {
                context.setError("Error loading token", "No token was found with an ID of " + id);
                return;
            }
            this.targetExpression.setValue(elContext, (Object)token);
            context.selectOutcome("success");
        }
        catch (Exception ex) {
            context.setError("Error loading token", ex);
            return;
        }
    }
}

