/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.jpdl;

import org.dom4j.Element;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.sim.jpdl.SimulationHandler;
import org.jbpm.sim.jpdl.SimulationNoop;

public class SimAction
extends Action {
    private static final long serialVersionUID = 1L;
    private boolean simulate = false;
    private boolean simulationHandlerChecked = false;

    public void read(Element actionElement, JpdlXmlReader jpdlReader) {
        String simulationClass;
        super.read(actionElement, jpdlReader);
        String simulation = actionElement.attributeValue("simulation");
        if ("execute".equals(simulation) || "simulation-action".equals(actionElement.getQName().getName())) {
            this.simulate = true;
        }
        if ((simulationClass = actionElement.attributeValue("simulation-class")) != null) {
            this.simulate = true;
            this.actionDelegation.setClassName(simulationClass);
            this.actionDelegation.setConfiguration(null);
        }
    }

    public void execute(ExecutionContext executionContext) throws Exception {
        if (!this.simulationHandlerChecked) {
            Object delegation = this.actionDelegation.getInstance();
            if (SimulationHandler.class.isAssignableFrom(delegation.getClass())) {
                this.simulate = true;
                this.referencedAction = new ActionHandlerDelegation((SimulationHandler)delegation);
            } else if (SimulationNoop.class.isAssignableFrom(delegation.getClass())) {
                this.simulate = false;
            }
            this.simulationHandlerChecked = true;
        }
        if (this.simulate) {
            super.execute(executionContext);
        }
    }

    private class ActionHandlerDelegation
    extends Action {
        private SimulationHandler delegate;

        public ActionHandlerDelegation(SimulationHandler delegate) {
            this.delegate = delegate;
        }

        public void execute(ExecutionContext executionContext) throws Exception {
            this.delegate.simExecute(executionContext);
        }
    }
}

