/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.def;

import desmoj.core.dist.Distribution;
import desmoj.core.dist.IntDistConstant;
import desmoj.core.dist.IntDistPoisson;
import desmoj.core.dist.IntDistUniform;
import desmoj.core.dist.RealDistConstant;
import desmoj.core.dist.RealDistErlang;
import desmoj.core.dist.RealDistExponential;
import desmoj.core.dist.RealDistNormal;
import desmoj.core.dist.RealDistUniform;
import desmoj.core.simulator.Model;
import org.jbpm.sim.exception.ExperimentConfigurationException;

public class DistributionDefinition {
    public static boolean showInTrace = true;
    public static boolean showInReport = true;
    private String name;
    private String type;
    private String sampleType;
    private String valueText;
    private String meanText;
    private String standardDeviationText;
    private String minText;
    private String maxText;
    private boolean nonNegative;

    public DistributionDefinition(String name, String type, String sampleType, String valueText, String meanText, String standardDeviationText, String minText, String maxText, boolean nonNegative) {
        this.name = name;
        this.type = type;
        this.sampleType = sampleType;
        this.valueText = valueText;
        this.meanText = meanText;
        this.standardDeviationText = standardDeviationText;
        this.minText = minText;
        this.maxText = maxText;
        this.nonNegative = nonNegative;
    }

    public Distribution createDistribution(Model owner) {
        Distribution dist = this.createDistributionObject(owner);
        dist.setNonNegative(this.nonNegative);
        return dist;
    }

    private Distribution createDistributionObject(Model owner) {
        try {
            if ("int".equals(this.sampleType)) {
                if ("constant".equals(this.type)) {
                    return new IntDistConstant(owner, this.name, Long.valueOf(this.valueText).longValue(), showInTrace, showInReport);
                }
                if ("poisson".equals(this.type)) {
                    return new IntDistPoisson(owner, this.name, Double.valueOf(this.meanText).doubleValue(), showInTrace, showInReport);
                }
                if ("uniform".equals(this.type)) {
                    return new IntDistUniform(owner, this.name, Long.valueOf(this.minText).longValue(), Long.valueOf(this.maxText).longValue(), showInTrace, showInReport);
                }
            } else if ("real".equals(this.sampleType)) {
                if ("constant".equals(this.type)) {
                    return new RealDistConstant(owner, this.name, Double.valueOf(this.valueText).doubleValue(), showInTrace, showInReport);
                }
                if ("normal".equals(this.type)) {
                    return new RealDistNormal(owner, this.name, Double.valueOf(this.meanText).doubleValue(), Double.valueOf(this.standardDeviationText).doubleValue(), showInTrace, showInReport);
                }
                if ("erlang".equals(this.type)) {
                    return new RealDistErlang(owner, this.name, 1L, Double.valueOf(this.meanText).doubleValue(), showInTrace, showInReport);
                }
                if ("uniform".equals(this.type)) {
                    return new RealDistUniform(owner, this.name, Double.valueOf(this.minText).doubleValue(), Double.valueOf(this.maxText).doubleValue(), showInTrace, showInReport);
                }
                if ("exponential".equals(this.type)) {
                    return new RealDistExponential(owner, this.name, Double.valueOf(this.meanText).doubleValue(), showInTrace, showInReport);
                }
            } else {
                if ("boolean".equals(this.sampleType)) {
                    throw new ExperimentConfigurationException("sample type boolean not yet supported.");
                }
                throw new ExperimentConfigurationException("sample type '" + this.sampleType + "' unknown.");
            }
            throw new ExperimentConfigurationException("distribution type '" + this.type + "' for sample type '" + this.sampleType + "' unknown.");
        }
        catch (NumberFormatException ex) {
            throw new ExperimentConfigurationException("number format exception " + ex.getMessage() + " while creating distribution '" + this.name + "'", ex);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getSampleType() {
        return this.sampleType;
    }

    public String getValueText() {
        return this.valueText;
    }

    public String getMeanText() {
        return this.meanText;
    }

    public String getStandardDeviationText() {
        return this.standardDeviationText;
    }

    public String getMinText() {
        return this.minText;
    }

    public String getMaxText() {
        return this.maxText;
    }
}

