/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.jpdl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.module.def.ModuleDefinition;
import org.jbpm.module.exe.ModuleInstance;
import org.jbpm.sim.datasource.ProcessDataFilter;
import org.jbpm.sim.datasource.ProcessDataSource;
import org.jbpm.sim.def.DistributionDefinition;
import org.jbpm.sim.def.ResourceRequirement;
import org.jbpm.sim.exception.ExperimentConfigurationException;
import org.jbpm.sim.jpdl.SimulationInstance;
import org.jbpm.taskmgmt.def.Task;

public class SimulationDefinition
extends ModuleDefinition {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(SimulationDefinition.class);
    private Map resourcePoolDefinitions = new HashMap();
    private List distributions = new ArrayList();
    private Map distributionMap = new HashMap();
    private Map resourceRequirements = new HashMap();
    private Map transitionProbabilities = new HashMap();
    private Map dataSources = new HashMap();
    private Map dataFilters = new HashMap();

    public ModuleInstance createInstance() {
        return new SimulationInstance(this);
    }

    public void addResourcePool(String poolName, Integer poolSize, Double costPerTimeUnit) {
        if (this.resourcePoolDefinitions.containsKey(poolName)) {
            Integer otherPoolSize = (Integer)((Object[])this.resourcePoolDefinitions.get(poolName))[0];
            if (poolSize > otherPoolSize) {
                this.resourcePoolDefinitions.put(poolName, new Object[]{poolSize, costPerTimeUnit});
                log.warn((Object)("resource pool '" + poolName + "' redefined in process '" + this.getProcessDefinition().getName() + "' with the bigger poolsize " + poolSize + ", was " + otherPoolSize + " before"));
            } else if (poolSize < otherPoolSize) {
                log.warn((Object)("resource pool '" + poolName + "' redefined in process '" + this.getProcessDefinition().getName() + "' with the smaler poolsize " + poolSize + " which is ignored. Poolsize still is " + otherPoolSize));
            }
        } else {
            this.resourcePoolDefinitions.put(poolName, new Object[]{poolSize, costPerTimeUnit});
        }
    }

    public void overwriteResourcePool(String poolName, Integer poolSize, Double costPerTimeUnit) {
        this.resourcePoolDefinitions.put(poolName, new Object[]{poolSize, costPerTimeUnit});
    }

    public void addResourceRequirement(Object processElement, String poolName, int amount) {
        ArrayList<ResourceRequirement> reqList = (ArrayList<ResourceRequirement>)this.resourceRequirements.get(processElement);
        if (reqList == null) {
            reqList = new ArrayList<ResourceRequirement>();
            this.resourceRequirements.put(processElement, reqList);
        }
        reqList.add(new ResourceRequirement(poolName, amount));
    }

    public void addDistribution(DistributionDefinition distDef) {
        this.distributions.add(distDef);
    }

    public void overwriteDistribution(DistributionDefinition distDef) {
        for (DistributionDefinition dd : new ArrayList(this.distributions)) {
            if (!dd.getName().equals(distDef.getName())) continue;
            this.distributions.remove(dd);
        }
        this.distributions.add(distDef);
    }

    public List getDistributions() {
        return this.distributions;
    }

    private void addToDistributionMap(Object key, String distributionName) {
        this.distributionMap.put(key, distributionName);
    }

    public void setStartDistribution(String distributionName) {
        this.addToDistributionMap(this.processDefinition, distributionName);
    }

    public void addTaskDistribution(Task task, String distributionName) {
        this.addToDistributionMap(task, distributionName);
    }

    public void addStateDistribution(Node state, String distributionName) {
        this.addToDistributionMap(state, distributionName);
    }

    public Map getDistributionMap() {
        return this.distributionMap;
    }

    public Map getResourceRequirements() {
        return this.resourceRequirements;
    }

    public void addTransitionProbability(Transition trans, double prob) {
        this.transitionProbabilities.put(trans, prob);
    }

    public Map getTransitionProbabilities() {
        return this.transitionProbabilities;
    }

    public Map getResourcePoolDefinitions() {
        return this.resourcePoolDefinitions;
    }

    public void setResourcePoolDefinitions(Map resourcePoolDefinitions) {
        this.resourcePoolDefinitions = resourcePoolDefinitions;
    }

    public void addDataSource(String name, ProcessDataSource src) {
        this.dataSources.put(name, src);
    }

    public ProcessDataSource getDataSource(String name) {
        ProcessDataSource result = (ProcessDataSource)this.dataSources.get(name);
        if (result == null) {
            throw new ExperimentConfigurationException("data source '" + name + "' not configured");
        }
        return result;
    }

    public void addDataFilter(String name, ProcessDataFilter filter) {
        this.dataFilters.put(name, filter);
    }

    public ProcessDataFilter getDataFilter(String name) {
        ProcessDataFilter result = (ProcessDataFilter)this.dataFilters.get(name);
        if (result == null) {
            throw new ExperimentConfigurationException("data filter '" + name + "' not configured");
        }
        return result;
    }
}

