/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.report.jasper;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PrinterName;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.engine.export.JRPrintServiceExporterParameter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.view.JasperViewer;
import org.jbpm.JbpmException;

public abstract class AbstractBaseJasperReport {
    private boolean initialized = false;
    private JasperReport mainReport;
    private Map subReports = new HashMap();
    private JasperPrint jasperPrint;

    public void show() {
        JasperViewer.viewReport((JasperPrint)this.getJasperPrint(), (boolean)false);
    }

    public void printOnDefaultPrinter(boolean withPrintDialog) {
        try {
            JasperPrint jp = this.getJasperPrint();
            JasperPrintManager.printPages((JasperPrint)jp, (int)0, (int)(jp.getPages().size() - 1), (boolean)withPrintDialog);
        }
        catch (JRException ex) {
            throw new JbpmException("could not print report", (Throwable)ex);
        }
    }

    public void print(String printerName) {
        HashPrintRequestAttributeSet printRequestAttributeSet = new HashPrintRequestAttributeSet();
        printRequestAttributeSet.add(MediaSizeName.ISO_A4);
        HashPrintServiceAttributeSet printServiceAttributeSet = new HashPrintServiceAttributeSet();
        printServiceAttributeSet.add(new PrinterName(printerName, null));
        JRPrintServiceExporter exporter = new JRPrintServiceExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.getJasperPrint());
        exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.PRINT_REQUEST_ATTRIBUTE_SET, (Object)printRequestAttributeSet);
        exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.PRINT_SERVICE_ATTRIBUTE_SET, (Object)printServiceAttributeSet);
        exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.DISPLAY_PAGE_DIALOG, (Object)Boolean.FALSE);
        exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.DISPLAY_PRINT_DIALOG, (Object)Boolean.FALSE);
        try {
            exporter.exportReport();
        }
        catch (JRException ex) {
            throw new JbpmException("could not print report", (Throwable)ex);
        }
    }

    public OutputStream getAsPDF() {
        try {
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            JasperExportManager.exportReportToPdfStream((JasperPrint)this.getJasperPrint(), (OutputStream)result);
            return result;
        }
        catch (JRException ex) {
            throw new JbpmException("could not export report to pdf", (Throwable)ex);
        }
    }

    private void initReports() {
        if (this.initialized) {
            return;
        }
        try {
            String resource = this.getReportPath();
            InputStream reportStream = this.getClass().getResourceAsStream(resource);
            if (reportStream == null) {
                throw new JbpmException("report resource not found: " + resource);
            }
            this.mainReport = (JasperReport)JRLoader.loadObject((InputStream)reportStream);
            Map subreports = this.getSubreportPaths();
            if (subreports != null) {
                for (String subreport : subreports.keySet()) {
                    resource = (String)subreports.get(subreport);
                    reportStream = this.getClass().getResourceAsStream(resource);
                    if (reportStream == null) {
                        throw new JbpmException("report resource not found: " + subreports.get(subreport));
                    }
                    this.subReports.put(subreport, JRLoader.loadObject((InputStream)reportStream));
                }
            }
            this.initialized = true;
        }
        catch (JRException ex) {
            throw new JbpmException("could not load report", (Throwable)ex);
        }
    }

    public JasperPrint getJasperPrint() {
        if (this.jasperPrint == null) {
            this.initReports();
            try {
                HashMap params = this.getReportParameters();
                if (params == null) {
                    params = new HashMap();
                }
                params.putAll(this.subReports);
                this.jasperPrint = JasperFillManager.fillReport((JasperReport)this.mainReport, params, (JRDataSource)new JRBeanArrayDataSource(this.getContent()));
            }
            catch (JRException ex) {
                throw new JbpmException("could not fill report", (Throwable)ex);
            }
        }
        return this.jasperPrint;
    }

    public abstract String getReportPath();

    public abstract Map getSubreportPaths();

    public abstract Map getReportParameters();

    public abstract Object[] getContent();
}

