/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.report;

import desmoj.core.dist.Distribution;
import desmoj.core.report.Message;
import desmoj.core.report.MessageReceiver;
import desmoj.core.report.Reporter;
import desmoj.core.simulator.Experiment;
import desmoj.core.simulator.Model;
import desmoj.core.simulator.QueueBased;
import desmoj.core.simulator.Reportable;
import desmoj.core.statistic.Count;
import desmoj.core.statistic.TimeSeries;
import desmoj.core.statistic.ValueStatistics;
import java.util.Collection;
import org.jbpm.sim.SimulationConstants;
import org.jbpm.sim.def.JbpmSimulationModel;
import org.jbpm.sim.report.ScenarioReport;
import org.jbpm.sim.report.dto.CountResult;
import org.jbpm.sim.report.dto.QueueStatisticsResult;
import org.jbpm.sim.report.dto.TimeSeriesResult;
import org.jbpm.sim.report.dto.UtilizationStatisticsResult;
import org.jbpm.sim.report.dto.ValueStatisticResult;

public class InMemoryOutput
implements MessageReceiver {
    private ScenarioReport report = new ScenarioReport();

    private String getScenarioName(Experiment experiment) {
        if (experiment.getName() != null && experiment.getName().indexOf(".") > -1) {
            return experiment.getName().substring(experiment.getName().indexOf(".") + 1);
        }
        return experiment.getName();
    }

    public void receive(Reporter r) {
        if (r == null || r.getReportable() == null) {
            return;
        }
        Reportable source = r.getReportable();
        String scenarioName = this.getScenarioName(r.getModel().getExperiment());
        JbpmSimulationModel jbpmModel = (JbpmSimulationModel)source.getModel();
        String name = jbpmModel.getShortNameFor(source.getName());
        if (source instanceof Model) {
            Model model = (Model)source;
            this.report.setScenarioName(scenarioName);
            this.report.setSimulationRunTime(model.currentTime().getTimeValue());
            this.report.setResetTime(model.resetAt().getTimeValue());
            String[] resourcePools = jbpmModel.getResourcePoolNames();
            for (int i = 0; i < resourcePools.length; ++i) {
                TimeSeries ts = jbpmModel.getResourcePoolTimeSeries(resourcePools[i]);
                String tsName = jbpmModel.getShortNameFor(ts.getName());
                this.report.addResourcePoolTimeSeries(new TimeSeriesResult(tsName, scenarioName, ts));
            }
            Collection businessFigureTypes = jbpmModel.getBusinessFigureTypes();
            for (String type : businessFigureTypes) {
                double sum = jbpmModel.getBusinessFigureSum(type);
                this.report.addBusinessFigure(type, sum);
            }
        } else if (source instanceof ValueStatistics) {
            ValueStatistics vs = (ValueStatistics)source;
            if (vs.getName().startsWith(SimulationConstants.NAME_PREFIX_WAITING_BEFORE_STATE) && vs.getName().endsWith(SimulationConstants.NAME_SUFFIX_WAITING_FOR_RESOURCE)) {
                this.report.addStateWaitStatistics(new ValueStatisticResult(name, scenarioName, vs));
            } else if (vs.getName().startsWith(SimulationConstants.NAME_PREFIX_PROCESS_CYCLE_TIME) && vs.getName().endsWith(SimulationConstants.NAME_SUFFIX_PROCESS_CYCLE_TIME)) {
                this.report.addProcessCycleTimeStatistics(new ValueStatisticResult(name, scenarioName, vs));
            } else {
                this.report.addMiscValueStatistics(new ValueStatisticResult(name, scenarioName, vs));
            }
        } else if (source instanceof QueueBased) {
            QueueBased queue = (QueueBased)source;
            if (queue.getName().startsWith(SimulationConstants.NAME_PREFIX_RESOURCE_QUEUE) && queue.getName().endsWith(SimulationConstants.NAME_SUFFIX_RESOURCE_QUEUE)) {
                this.report.addResourcePoolWaitingTimes(new QueueStatisticsResult(name, scenarioName, queue));
            } else if (queue.getName().startsWith(SimulationConstants.NAME_PREFIX_RESOURCE_POOL) && queue.getName().endsWith(SimulationConstants.NAME_SUFFIX_RESOURCE_POOL)) {
                this.report.addResourcePoolUtilization(new UtilizationStatisticsResult(name, scenarioName, queue, jbpmModel.getResourcePool(name).getCostPerTimeUnit()));
            } else {
                this.report.addMiscQueueStatistics(new QueueStatisticsResult(name, scenarioName, queue));
            }
        } else if (source instanceof Count) {
            Count count = (Count)source;
            if (count.getName().startsWith(SimulationConstants.NAME_PREFIX_PROCESS_END_STATE) && count.getName().endsWith(SimulationConstants.NAME_SUFFIX_PROCESS_END_STATE)) {
                this.report.addProcessEndCount(new CountResult(name, scenarioName, count));
            } else if (count.getName().startsWith(SimulationConstants.NAME_PREFIX_PROCESS_START) && count.getName().endsWith(SimulationConstants.NAME_SUFFIX_PROCESS_START)) {
                this.report.addProcessStartCount(new CountResult(name, scenarioName, count));
            }
        } else if (source instanceof Distribution) {
            // empty if block
        }
    }

    public void receive(Message m) {
    }

    public ScenarioReport getReport() {
        return this.report;
    }
}

