/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.def;

import desmoj.core.dist.Distribution;
import desmoj.core.dist.RealDist;
import desmoj.core.dist.RealDistUniform;
import desmoj.core.simulator.Model;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.sim.exception.ExperimentConfigurationException;

public class LeavingTransitionProbabilityConfiguration {
    private Node node;
    private RealDist distribution;
    private double probabilitySum = 0.0;
    private Map transitionProbabilityRange = new HashMap();

    public LeavingTransitionProbabilityConfiguration(Node node) {
        this.node = node;
    }

    public LeavingTransitionProbabilityConfiguration(Node node, Transition trans, double probability) {
        this(node);
        this.addTransition(trans, probability);
    }

    public void addTransition(Transition trans, double probability) {
        this.transitionProbabilityRange.put(trans, new double[]{this.probabilitySum, this.probabilitySum + probability});
        this.probabilitySum += probability;
    }

    public Distribution createDistribution(Model owner) {
        this.distribution = new RealDistUniform(owner, "Selecting outgoing transition of " + this.node, 0.0, this.probabilitySum, true, false);
        return this.distribution;
    }

    public Transition decideOutgoingTransition() {
        double sample = this.distribution.sample();
        Iterator iterator = this.transitionProbabilityRange.keySet().iterator();
        while (iterator.hasNext()) {
            Transition trans = (Transition)iterator.next();
            double[] range = (double[])this.transitionProbabilityRange.get(trans);
            if (!(sample >= range[0]) || !(sample < range[1])) continue;
            return trans;
        }
        throw new ExperimentConfigurationException("Couldn't find a transition for the sample " + sample + ". Wired, this should never happen!");
    }

    public Node getNode() {
        return this.node;
    }
}

