/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.def;

import desmoj.core.simulator.Entity;
import desmoj.core.simulator.Model;
import desmoj.core.simulator.Queue;
import desmoj.core.simulator.SimTime;
import desmoj.core.statistic.Tally;
import desmoj.core.statistic.TimeSeries;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.sim.SimulationConstants;
import org.jbpm.sim.def.JbpmSimulationModel;
import org.jbpm.sim.entity.ResourceEntity;

public class ResourcePool {
    private static Log log = LogFactory.getLog((Class)ResourcePool.class);
    private String poolName;
    private double costPerTimeUnit;
    private Queue pool;
    private TimeSeries availableResourceTimeSeries;
    private Queue resourceQueue;
    private Tally waitTimeTally;
    private Tally workTimeHistogram;

    public ResourcePool(JbpmSimulationModel owner, String poolName, int capacity, double costPerTimeUnit) {
        log.debug((Object)("add new resource pool '" + poolName + "' with capacity " + capacity + " and costs " + costPerTimeUnit));
        this.poolName = poolName;
        this.costPerTimeUnit = costPerTimeUnit;
        this.pool = new Queue((Model)owner, owner.buildName(this, SimulationConstants.NAME_PREFIX_RESOURCE_POOL, SimulationConstants.NAME_SUFFIX_RESOURCE_POOL), 0, capacity, true, true);
        for (int i = 0; i < capacity; ++i) {
            this.pool.insert((Entity)new ResourceEntity(owner, "Resource from " + poolName));
        }
        this.resourceQueue = new Queue((Model)owner, owner.buildName(this, SimulationConstants.NAME_PREFIX_RESOURCE_QUEUE, SimulationConstants.NAME_SUFFIX_RESOURCE_QUEUE), 0, 0, true, true);
        this.availableResourceTimeSeries = new TimeSeries((Model)owner, owner.buildName(this, SimulationConstants.NAME_PREFIX_RESOURCE_USAGE_TIMESERIES, SimulationConstants.NAME_SUFFIX_RESOURCE_USAGE_TIMESERIES), new SimTime(0.0), new SimTime(Double.MAX_VALUE), false);
        this.availableResourceTimeSeries.connectToPlotter(new Observer(){

            public void update(Observable observable, Object o) {
            }
        });
        this.availableResourceTimeSeries.reset();
        this.waitTimeTally = new Tally((Model)owner, owner.buildName(this, SimulationConstants.NAME_PREFIX_WAITING_FOR_RESOURCE, SimulationConstants.NAME_SUFFIX_WAITING_FOR_RESOURCE), false, false);
        this.waitTimeTally.reset();
    }

    public Queue getPool() {
        return this.pool;
    }

    public TimeSeries getAvailableResourceTimeSeries() {
        return this.availableResourceTimeSeries;
    }

    public Queue getResourceQueue() {
        return this.resourceQueue;
    }

    public Tally getWaitTimeTally() {
        return this.waitTimeTally;
    }

    public Tally getWorkTimeTally() {
        return this.workTimeHistogram;
    }

    public String getName() {
        return this.getPoolName();
    }

    public String getPoolName() {
        return this.poolName;
    }

    public int getCapacity() {
        return this.pool.getQueueLimit();
    }

    public int getAvailableResources() {
        return this.pool.length();
    }

    public String toString() {
        return "ResourcePool(" + this.poolName + ")";
    }

    public double getCostPerTimeUnit() {
        return this.costPerTimeUnit;
    }

    public void setCostPerTimeUnit(double costPerTimeUnit) {
        this.costPerTimeUnit = costPerTimeUnit;
    }
}

