/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.report.dto;

import desmoj.core.simulator.QueueBased;
import org.jbpm.sim.report.dto.BaseResult;

public class UtilizationStatisticsResult
extends BaseResult {
    private static final long serialVersionUID = -1158340031538382394L;
    private long observations;
    private int poolSize;
    private int minAvailabe;
    private int maxAvailabe;
    private double averageUnutilizedAmount;
    private double stdDevUnutilizedAmount;
    private double maxUnutilizedTime;
    private double averageUnutilizedTime;
    private long zeroWaits;
    private double costs;
    private double costsPerTimeUnit;

    public UtilizationStatisticsResult(String name, String scenario, long observations, int poolSize, int minAvailabe, int maxAvailabe, double averageUnutilizedAmount, double stdDevUnutilizedAmount, double maxUnutilizedTime, double averageUnutilizedTime, long zeroWaits, double costsPerTimeUnit) {
        super(name, scenario);
        this.observations = observations;
        this.poolSize = poolSize;
        this.minAvailabe = minAvailabe;
        this.maxAvailabe = maxAvailabe;
        this.averageUnutilizedAmount = averageUnutilizedAmount;
        this.stdDevUnutilizedAmount = stdDevUnutilizedAmount;
        this.maxUnutilizedTime = maxUnutilizedTime;
        this.averageUnutilizedTime = averageUnutilizedTime;
        this.zeroWaits = zeroWaits;
        this.costsPerTimeUnit = costsPerTimeUnit;
    }

    public UtilizationStatisticsResult(String name, String scenarioName, QueueBased queue, double costsPerTimeUnit) {
        this(name, scenarioName, queue.getObservations(), queue.getQueueLimit(), queue.minLength(), queue.maxLength(), queue.averageLength(), queue.stdDevLength(), queue.maxWaitTime().getTimeValue(), queue.averageWaitTime().getTimeValue(), queue.zeroWaits(), costsPerTimeUnit);
    }

    public void calculateCosts(double unutilizedCostFactor, double runtime) {
        double utilized = ((double)this.getPoolSize() - this.getAverageUnutilizedAmount()) * runtime * this.costsPerTimeUnit;
        double unutilized = this.getAverageUnutilizedAmount() * unutilizedCostFactor * runtime * this.costsPerTimeUnit;
        this.costs = utilized + unutilized;
    }

    public double getAverageUtilization() {
        return ((double)this.getPoolSize() - this.getAverageUnutilizedAmount()) / (double)this.getPoolSize();
    }

    public long getObservations() {
        return this.observations;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public int getMinAvailabe() {
        return this.minAvailabe;
    }

    public int getMaxAvailabe() {
        return this.maxAvailabe;
    }

    public double getAverageUnutilizedAmount() {
        return this.averageUnutilizedAmount;
    }

    public double getStdDevUnutilizedAmount() {
        return this.stdDevUnutilizedAmount;
    }

    public double getMaxUnutilizedTime() {
        return this.maxUnutilizedTime;
    }

    public double getAverageUnutilizedTime() {
        return this.averageUnutilizedTime;
    }

    public long getZeroWaits() {
        return this.zeroWaits;
    }

    public double getCosts() {
        return this.costs;
    }
}

