/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.def;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.sim.def.JbpmSimulationScenario;
import org.jbpm.sim.exception.ExperimentConfigurationException;
import org.jbpm.sim.exe.SimulationProgressListener;
import org.jbpm.sim.report.ExperimentReport;
import org.jbpm.sim.report.ScenarioReport;

public class JbpmSimulationExperiment {
    public static int MILLISECONDS = 0;
    public static int SECONDS = 1;
    public static int MINUTES = 2;
    public static int HOURS = 3;
    private String name;
    private double simulationRunTime = 1440.0;
    private double resetTime = 0.0;
    private Date realStartDate = new Date(0L);
    private int timeUnit = MINUTES;
    private String currency = "EUR";
    private double unutilizedTimeCostFactor = 0.0;
    private Map scenarios = new HashMap();
    private String outputPathName = ".";
    private boolean writeDesmojHtmlOutput = false;
    private boolean rememberEndedProcessInstances = false;
    private long seed = 0L;
    private ExperimentReport report = null;

    public JbpmSimulationExperiment(String name) {
        if (name == null) {
            name = "JbpmSimulationExperiment";
        }
        this.name = name;
    }

    public void addScenario(JbpmSimulationScenario scenario) {
        this.scenarios.put(scenario.getName(), scenario);
    }

    public void run() {
        this.run(null);
    }

    public void run(SimulationProgressListener listener) {
        this.report = new ExperimentReport(this.getName(), this.getCurrency());
        int scenarioNumber = 0;
        int count = this.scenarios.values().size();
        for (JbpmSimulationScenario scenario : this.scenarios.values()) {
            if (listener != null) {
                listener.newScenario(scenario.getName(), scenarioNumber, count);
            }
            if (scenario.isExecute()) {
                scenario.runSimulation(this, this.getWriteDesmojHtmlOutput(), this.rememberEndedProcessInstances, this.seed);
                ScenarioReport scenarioReport = scenario.getScenarioReport();
                scenarioReport.calculateResourceCosts(this.unutilizedTimeCostFactor);
                this.report.addScenarioReport(scenarioReport);
            }
            ++scenarioNumber;
        }
    }

    public Collection getScenarios() {
        return this.scenarios.values();
    }

    public JbpmSimulationScenario getScenario(String name) {
        return (JbpmSimulationScenario)this.scenarios.get(name);
    }

    public ScenarioReport getSimulationReportForScenario(String scenarioName) {
        return ((JbpmSimulationScenario)this.scenarios.get(scenarioName)).getScenarioReport();
    }

    public void setSimulationRunTime(double simulationRunTime) {
        this.simulationRunTime = simulationRunTime;
    }

    public void setRealStartDate(String realStartTimeString) {
        try {
            this.setRealStartDate(new SimpleDateFormat("dd.MM.yyyy HH:mm:ss:SSS").parse(realStartTimeString));
        }
        catch (ParseException e) {
            throw new ExperimentConfigurationException("real start date '" + realStartTimeString + "' does not match pattern '" + "dd.MM.yyyy HH:mm:ss:SSS" + "'", e);
        }
    }

    public void setRealStartDate(Date realStartDate) {
        this.realStartDate = realStartDate;
    }

    public void setTimeUnit(int timeUnit) {
        this.timeUnit = timeUnit;
    }

    public void setOutputPathName(String outputPathName) {
        this.outputPathName = outputPathName == null ? "." : outputPathName;
    }

    public String getName() {
        return this.name;
    }

    public double getSimulationRunTime() {
        return this.simulationRunTime;
    }

    public Date getRealStartDate() {
        return this.realStartDate;
    }

    public int getTimeUnit() {
        return this.timeUnit;
    }

    public String getOutputPathName() {
        return this.outputPathName;
    }

    public boolean getWriteDesmojHtmlOutput() {
        return this.writeDesmojHtmlOutput;
    }

    public void setWriteDesmojHtmlOutput(boolean writeDesmojHtmlOutput) {
        this.writeDesmojHtmlOutput = writeDesmojHtmlOutput;
    }

    public ExperimentReport getReport() {
        return this.report;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public boolean isRememberEndedProcessInstances() {
        return this.rememberEndedProcessInstances;
    }

    public void setRememberEndedProcessInstances(boolean rememberEndedProcessInstances) {
        this.rememberEndedProcessInstances = rememberEndedProcessInstances;
    }

    public double getUnutilizedTimeCostFactor() {
        return this.unutilizedTimeCostFactor;
    }

    public void setUnutilizedTimeCostFactor(double unutilizedTimeCostFactor) {
        this.unutilizedTimeCostFactor = unutilizedTimeCostFactor;
    }

    public double getResetTime() {
        return this.resetTime;
    }

    public void setResetTime(double resetTime) {
        this.resetTime = resetTime;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }
}

