/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.Serializable;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.jbpm.AbstractJbpmTestCase;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.db.ContextSession;
import org.jbpm.db.GraphSession;
import org.jbpm.db.JbpmSchema;
import org.jbpm.db.JobSession;
import org.jbpm.db.LoggingSession;
import org.jbpm.db.TaskMgmtSession;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.job.Job;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.logging.log.ProcessLog;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;
import org.jbpm.taskmgmt.exe.TaskInstance;

public abstract class AbstractDbTestCase
extends AbstractJbpmTestCase {
    private static final Log log = LogFactory.getLog(AbstractDbTestCase.class);
    protected JbpmConfiguration jbpmConfiguration;
    protected JbpmContext jbpmContext;
    protected SchemaExport schemaExport;
    protected Session session;
    protected GraphSession graphSession;
    protected TaskMgmtSession taskMgmtSession;
    protected ContextSession contextSession;
    protected JobSession jobSession;
    protected LoggingSession loggingSession;
    protected JobExecutor jobExecutor;

    protected void setUp() throws Exception {
        super.setUp();
        this.beginSessionTransaction();
    }

    protected void tearDown() throws Exception {
        this.commitAndCloseSession();
        this.ensureCleanDatabase();
        super.tearDown();
    }

    private void ensureCleanDatabase() {
        boolean hasLeftOvers = false;
        DbPersistenceServiceFactory dbPersistenceServiceFactory = (DbPersistenceServiceFactory)this.getJbpmConfiguration().getServiceFactory("persistence");
        Configuration configuration = dbPersistenceServiceFactory.getConfiguration();
        JbpmSchema jbpmSchema = new JbpmSchema(configuration);
        Map jbpmTablesRecordCount = jbpmSchema.getJbpmTablesRecordCount();
        for (Map.Entry entry : jbpmTablesRecordCount.entrySet()) {
            String tableName = (String)entry.getKey();
            Integer count = (Integer)entry.getValue();
            if (count != null && count == 0) continue;
            hasLeftOvers = true;
        }
        if (hasLeftOvers) {
            // empty if block
        }
    }

    protected String getHibernateDialect() {
        DbPersistenceServiceFactory factory = (DbPersistenceServiceFactory)this.jbpmContext.getServiceFactory("persistence");
        return factory.getConfiguration().getProperty("hibernate.dialect");
    }

    protected void beginSessionTransaction() {
        this.createJbpmContext();
        this.initializeMembers();
    }

    protected void commitAndCloseSession() {
        this.closeJbpmContext();
        this.resetMembers();
    }

    protected void newTransaction() {
        this.commitAndCloseSession();
        this.beginSessionTransaction();
    }

    protected ProcessInstance saveAndReload(ProcessInstance pi) {
        this.jbpmContext.save(pi);
        this.newTransaction();
        return this.graphSession.loadProcessInstance(pi.getId());
    }

    protected TaskInstance saveAndReload(TaskInstance taskInstance) {
        this.jbpmContext.save(taskInstance);
        this.newTransaction();
        return (TaskInstance)this.session.load(TaskInstance.class, (Serializable)new Long(taskInstance.getId()));
    }

    protected ProcessDefinition saveAndReload(ProcessDefinition pd) {
        this.graphSession.saveProcessDefinition(pd);
        this.newTransaction();
        return this.graphSession.loadProcessDefinition(pd.getId());
    }

    protected ProcessLog saveAndReload(ProcessLog processLog) {
        this.loggingSession.saveProcessLog(processLog);
        this.newTransaction();
        return this.loggingSession.loadProcessLog(processLog.getId());
    }

    protected void createSchema() {
        this.getJbpmConfiguration().createSchema();
    }

    protected void cleanSchema() {
        this.getJbpmConfiguration().cleanSchema();
    }

    protected void dropSchema() {
        this.getJbpmConfiguration().dropSchema();
    }

    protected String getJbpmTestConfig() {
        return "org/jbpm/db/jbpm.db.test.cfg.xml";
    }

    protected JbpmConfiguration getJbpmConfiguration() {
        if (this.jbpmConfiguration == null) {
            String jbpmTestConfiguration = this.getJbpmTestConfig();
            this.jbpmConfiguration = JbpmConfiguration.getInstance(jbpmTestConfiguration);
        }
        return this.jbpmConfiguration;
    }

    protected void createJbpmContext() {
        this.jbpmContext = this.getJbpmConfiguration().createJbpmContext();
    }

    protected void closeJbpmContext() {
        if (this.jbpmContext != null) {
            this.jbpmContext.close();
            this.jbpmContext = null;
        }
    }

    protected void startJobExecutor() {
        this.jobExecutor = this.getJbpmConfiguration().getJobExecutor();
        this.jobExecutor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForJobs(long timeout) {
        TimerTask interruptTask = new TimerTask(){
            Thread testThread = Thread.currentThread();

            public void run() {
                log.debug((Object)("test " + AbstractDbTestCase.this.getName() + " took too long. going to interrupt..."));
                this.testThread.interrupt();
            }
        };
        Timer timer = new Timer();
        timer.schedule(interruptTask, timeout);
        try {
            while (this.getNbrOfJobsAvailable() > 0) {
                log.debug((Object)"going to sleep for 200 millis, waiting for the job executor to process more jobs");
                Thread.sleep(200L);
            }
        }
        catch (InterruptedException e) {
            AbstractDbTestCase.fail((String)("test execution exceeded treshold of " + timeout + " milliseconds"));
        }
        finally {
            timer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNbrOfJobsAvailable() {
        if (this.session != null) {
            return this.getNbrOfJobsAvailable(this.session);
        }
        this.beginSessionTransaction();
        try {
            int n = this.getNbrOfJobsAvailable(this.session);
            return n;
        }
        finally {
            this.commitAndCloseSession();
        }
    }

    private int getNbrOfJobsAvailable(Session session) {
        int nbrOfJobsAvailable = 0;
        Number jobs = (Number)session.createQuery("select count(*) from org.jbpm.job.Job").uniqueResult();
        log.debug((Object)("there are " + jobs + " jobs in the database"));
        if (jobs != null) {
            nbrOfJobsAvailable = jobs.intValue();
        }
        return nbrOfJobsAvailable;
    }

    protected int getTimerCount() {
        Number timerCount = (Number)this.session.createQuery("select count(*) from org.jbpm.job.Timer").uniqueResult();
        log.debug((Object)("there are " + timerCount + " timers in the database"));
        return timerCount.intValue();
    }

    protected Job getJob() {
        return (Job)this.session.createQuery("from org.jbpm.job.Job").uniqueResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processJobs(long maxWait) {
        this.commitAndCloseSession();
        this.startJobExecutor();
        try {
            this.waitForJobs(maxWait);
        }
        finally {
            this.stopJobExecutor();
            this.beginSessionTransaction();
        }
    }

    protected void stopJobExecutor() {
        if (this.jobExecutor != null) {
            try {
                this.jobExecutor.stopAndJoin();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("waiting for job executor to stop and join got interrupted", e);
            }
        }
    }

    protected void initializeMembers() {
        this.session = this.jbpmContext.getSession();
        this.graphSession = this.jbpmContext.getGraphSession();
        this.taskMgmtSession = this.jbpmContext.getTaskMgmtSession();
        this.loggingSession = this.jbpmContext.getLoggingSession();
        this.jobSession = this.jbpmContext.getJobSession();
        this.contextSession = this.jbpmContext.getContextSession();
    }

    protected void resetMembers() {
        this.session = null;
        this.graphSession = null;
        this.taskMgmtSession = null;
        this.loggingSession = null;
        this.jobSession = null;
        this.contextSession = null;
    }
}

