/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.jta;

import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.util.JTAHelper;
import org.jbpm.JbpmException;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;
import org.jbpm.persistence.jta.JtaDbPersistenceServiceFactory;

public class JtaDbPersistenceService
extends DbPersistenceService {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(JtaDbPersistenceService.class);
    private UserTransaction userTransaction;

    public JtaDbPersistenceService(DbPersistenceServiceFactory persistenceServiceFactory) {
        super(persistenceServiceFactory);
        if (!this.isJtaTransactionInProgress()) {
            this.beginJtaTransaction();
        }
    }

    protected boolean isTransactionActive() {
        return this.isJtaTransactionInProgress();
    }

    public void close() {
        super.close();
        if (this.userTransaction != null) {
            this.endJtaTransaction();
        }
    }

    boolean isJtaTransactionInProgress() {
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)this.getSessionFactory();
        return JTAHelper.isTransactionInProgress((SessionFactoryImplementor)sessionFactory);
    }

    void beginJtaTransaction() {
        try {
            log.debug((Object)"begin user transaction");
            this.userTransaction = ((JtaDbPersistenceServiceFactory)this.persistenceServiceFactory).getUserTransaction();
            this.userTransaction.begin();
        }
        catch (Exception e) {
            throw new JbpmException("couldn't begin user transaction", e);
        }
    }

    void endJtaTransaction() {
        if (this.isRollbackOnly() || JTAHelper.isRollback((int)this.getJtaTransactionStatus())) {
            log.debug((Object)"rolling back user transaction");
            try {
                this.userTransaction.rollback();
            }
            catch (Exception e) {
                throw new JbpmException("couldn't rollback user transaction", e);
            }
        }
        log.debug((Object)"committing user transaction");
        try {
            this.userTransaction.commit();
        }
        catch (Exception e) {
            throw new JbpmException("couldn't commit user transaction", e);
        }
    }

    int getJtaTransactionStatus() {
        try {
            return this.userTransaction.getStatus();
        }
        catch (SystemException e) {
            throw new JbpmException("couldn't get status for user transaction", e);
        }
    }

    public boolean isJtaTxCreated() {
        return this.userTransaction != null;
    }
}

