/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.util.List;
import org.jbpm.JbpmContext;
import org.jbpm.command.AbstractGetObjectBaseCommand;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class GetTaskInstanceCommand
extends AbstractGetObjectBaseCommand {
    private static final long serialVersionUID = -8436697080972165601L;
    private long taskInstanceId;
    private long tokenId;
    private long processInstanceId;
    private String configuredGuiElement;

    public GetTaskInstanceCommand() {
    }

    public GetTaskInstanceCommand(long taskInstanceId) {
        this.taskInstanceId = taskInstanceId;
    }

    public GetTaskInstanceCommand(long taskInstanceId, boolean includeVariables, boolean includeLogs) {
        super(includeVariables, includeLogs);
        this.taskInstanceId = taskInstanceId;
    }

    public GetTaskInstanceCommand(long taskInstanceId, String[] variablesToInclude) {
        super(variablesToInclude);
        this.taskInstanceId = taskInstanceId;
    }

    public Object execute(JbpmContext jbpmContext) throws Exception {
        if (this.taskInstanceId > 0L) {
            TaskInstance taskInstance = jbpmContext.getTaskInstance(this.taskInstanceId);
            if (taskInstance != null) {
                this.retrieveTaskInstanceDetails(taskInstance);
            }
            return taskInstance;
        }
        if (this.tokenId > 0L) {
            List result = jbpmContext.getTaskMgmtSession().findTaskInstancesByToken(this.tokenId);
            for (TaskInstance ti : result) {
                this.retrieveTaskInstanceDetails(ti);
            }
            return result;
        }
        if (this.processInstanceId > 0L) {
            List result = jbpmContext.getTaskMgmtSession().findTaskInstancesByProcessInstance(jbpmContext.getProcessInstance(this.processInstanceId));
            for (TaskInstance ti : result) {
                this.retrieveTaskInstanceDetails(ti);
            }
            return result;
        }
        return null;
    }

    public long getTaskInstanceId() {
        return this.taskInstanceId;
    }

    public void setTaskInstanceId(long taskInstanceId) {
        this.taskInstanceId = taskInstanceId;
    }

    public long getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(long tokenId) {
        this.tokenId = tokenId;
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }
}

